/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.cluster.ReaderWriter;
import co.paralleluniverse.galaxy.cluster.ReaderWriters;
import com.google.common.base.Throwables;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class IpConstants {
    public static final String IP_ADDRESS = "ip_addr";
    public static final String IP_COMM_PORT = "ip_port";
    public static final String IP_SERVER_PORT = "ip_server_port";
    public static final String IP_SLAVE_PORT = "ip_slave_port";
    public static final ReaderWriter<InetAddress> INET_ADDRESS_READER_WRITER = new ReaderWriter<InetAddress>(){

        @Override
        public InetAddress read(byte[] data) {
            try {
                String strAddress = ReaderWriters.STRING.read(data);
                return InetAddress.getByName(strAddress);
            }
            catch (UnknownHostException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }

        @Override
        public byte[] write(InetAddress value) {
            return ReaderWriters.STRING.write(value.getHostAddress());
        }
    };
    public static final ReaderWriter<InetSocketAddress> INET_SOCKET_ADDRESS_READER_WRITER = new ReaderWriter<InetSocketAddress>(){

        @Override
        public InetSocketAddress read(byte[] data) {
            String strAddress = ReaderWriters.STRING.read(data);
            int index = strAddress.lastIndexOf(58);
            String host = strAddress.substring(0, index);
            int port = Integer.parseInt(strAddress.substring(index + 1));
            return new InetSocketAddress(host, port);
        }

        @Override
        public byte[] write(InetSocketAddress value) {
            return ReaderWriters.STRING.write(value.toString());
        }
    };

    private IpConstants() {
    }
}

