/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import java.net.InetSocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;

public abstract class IpFilteringHandler
implements ChannelUpstreamHandler {
    protected abstract boolean accept(ChannelHandlerContext var1, ChannelEvent var2, InetSocketAddress var3) throws Exception;

    protected boolean isBlocked(ChannelHandlerContext ctx) {
        return ctx.getAttachment() != null;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e;
            switch (evt.getState()) {
                case OPEN: 
                case BOUND: {
                    if (this.isBlocked(ctx)) {
                        return;
                    }
                    ctx.sendUpstream(e);
                    return;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)e.getChannel().getRemoteAddress();
                        if (!this.accept(ctx, e, inetSocketAddress)) {
                            ctx.setAttachment((Object)Boolean.TRUE);
                            Channels.close((Channel)e.getChannel());
                            if (this.isBlocked(ctx)) {
                                return;
                            }
                        }
                        ctx.setAttachment(null);
                        break;
                    }
                    if (!this.isBlocked(ctx)) break;
                    return;
                }
            }
        }
        if (this.isBlocked(ctx)) {
            return;
        }
        ctx.sendUpstream(e);
    }
}

