/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;

public class LoggingHandler
extends SimpleChannelUpstreamHandler {
    private final Logger logger;

    public LoggingHandler(Logger logger) {
        this.logger = logger;
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.logger.info("Channel {} closed.", (Object)e.getChannel());
        super.channelClosed(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.logger.info("Channel {} connected to {}", (Object)e.getChannel(), (Object)e.getChannel().getRemoteAddress());
        super.channelConnected(ctx, e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.logger.info("Channel {} disconnected from {}", (Object)e.getChannel(), (Object)e.getChannel().getRemoteAddress());
        super.channelDisconnected(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.logger.warn("Exception caught in channel " + e.getChannel() + ": " + " " + e.getCause().getClass().getName() + " " + e.getCause().getMessage(), e.getCause());
        this.logger.debug("Exception caught in channel", e.getCause());
        super.exceptionCaught(ctx, e);
    }
}

