/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.common.collection.Util;
import co.paralleluniverse.galaxy.core.Message;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePacket
implements Iterable<Message>,
Cloneable {
    private int size;
    private int numBuffers;
    private transient boolean multicast;
    private transient long timestamp;
    private ArrayList<Message> messages = new ArrayList();
    private static final Logger LOG = LoggerFactory.getLogger(MessagePacket.class);

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void addMessage(Message message) {
        assert (this.messages.size() < 256);
        this.messages.add(message);
        this.size += message.size();
        this.numBuffers += 1 + message.getNumDataBuffers();
    }

    public boolean removeMessage(Message m) {
        int index = this.messages.indexOf(m);
        Message message = this.messages.get(index);
        if (index >= 0) {
            this.messages.remove(index);
            this.messageRemoved(message);
            return true;
        }
        return false;
    }

    public boolean removeMessage(long id) {
        Iterator<Message> it = this.messages.iterator();
        while (it.hasNext()) {
            Message message = it.next();
            if (message.getMessageId() != id) continue;
            it.remove();
            this.messageRemoved(message);
            return true;
        }
        return false;
    }

    private void messageRemoved(Message message) {
        this.size -= message.size();
        this.numBuffers -= 1 + message.getNumDataBuffers();
    }

    public Message getMessage(Message m) {
        int index = this.messages.indexOf(m);
        if (index < 0) {
            return null;
        }
        Message message = this.messages.get(index);
        return message;
    }

    public boolean contains(Message m) {
        return this.messages.contains(m);
    }

    public boolean contains(long id) {
        for (Message message : this.messages) {
            if (message.getMessageId() != id) continue;
            return true;
        }
        return false;
    }

    public int numMessages() {
        return this.messages.size();
    }

    public ArrayList<Message> getMessages() {
        return this.messages;
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public void setMulticast() {
        this.multicast = true;
    }

    @Override
    public Iterator<Message> iterator() {
        return this.wrapIterator(this.messages.iterator());
    }

    public Iterator<Message> reverseIterator() {
        return this.wrapIterator(Util.reverse(this.messages).iterator());
    }

    private Iterator<Message> wrapIterator(final Iterator<Message> it) {
        return new Iterator<Message>(){
            private Message message;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Message next() {
                this.message = (Message)it.next();
                return this.message;
            }

            @Override
            public void remove() {
                it.remove();
                MessagePacket.this.messageRemoved(this.message);
            }
        };
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public int sizeInBytes() {
        return this.size;
    }

    public int getNumBuffers() {
        return this.numBuffers;
    }

    public ByteBuffer[] toByteBuffers() {
        ByteBuffer[] buffers = new ByteBuffer[this.numBuffers];
        int i = 0;
        for (Message message : this.messages) {
            ByteBuffer[] bs;
            for (ByteBuffer b : bs = message.toByteBuffers()) {
                if (b != null) {
                    b.rewind();
                }
                buffers[i++] = b;
            }
        }
        return buffers;
    }

    public void fromByteBuffer(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("decoding. remaining " + buffer.remaining());
            }
            Message fromByteBuffer = Message.fromByteBuffer(buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("decoded " + fromByteBuffer);
            }
            this.addMessage(fromByteBuffer);
        }
    }

    public short getNode() {
        return this.messages.iterator().next().getNode();
    }

    public void setNode(short node) {
        for (Message m : this.messages) {
            m.setNode(node);
        }
    }

    public String toString() {
        return "MessagePacket[" + this.messages + ']';
    }

    public MessagePacket clone() {
        try {
            MessagePacket clone = (MessagePacket)super.clone();
            clone.messages = (ArrayList)this.messages.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

