/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.netty.MessagePacket;
import co.paralleluniverse.galaxy.netty.OneToOneCodec;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessagePacketCodec
extends OneToOneCodec {
    private static final Logger LOG = LoggerFactory.getLogger(MessagePacketCodec.class);

    @Override
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        MessagePacket packet = (MessagePacket)msg;
        ByteBuffer[] toByteBuffers = packet.toByteBuffers();
        if (LOG.isDebugEnabled()) {
            int size = 0;
            for (ByteBuffer byteBuffer : toByteBuffers) {
                size += byteBuffer.remaining();
            }
            LOG.debug("encoding size " + size + " " + packet);
        }
        return ChannelBuffers.wrappedBuffer((ByteBuffer[])toByteBuffers);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        ChannelBuffer buffer = (ChannelBuffer)msg;
        MessagePacket packet = new MessagePacket();
        ByteBuffer toByteBuffer = buffer.toByteBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("decoding size " + toByteBuffer.remaining());
        }
        packet.fromByteBuffer(toByteBuffer);
        return packet;
    }
}

