/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.UpstreamMessageEvent;

public abstract class OneToOneCodec
implements ChannelDownstreamHandler,
ChannelUpstreamHandler {
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        Object encodedMessage;
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object originalMessage = e.getMessage();
        if (originalMessage == (encodedMessage = this.encode(ctx, e.getChannel(), originalMessage))) {
            ctx.sendDownstream(evt);
        } else if (encodedMessage != null) {
            ctx.sendDownstream((ChannelEvent)new DownstreamMessageEvent(ctx.getChannel(), e.getFuture(), encodedMessage, e.getRemoteAddress()));
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        Object decodedMessage;
        if (!(evt instanceof MessageEvent)) {
            ctx.sendUpstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object originalMessage = e.getMessage();
        if (originalMessage == (decodedMessage = this.decode(ctx, e.getChannel(), originalMessage))) {
            ctx.sendUpstream(evt);
        } else if (decodedMessage != null) {
            ctx.sendUpstream((ChannelEvent)new UpstreamMessageEvent(ctx.getChannel(), decodedMessage, e.getRemoteAddress()));
        }
    }

    protected abstract Object encode(ChannelHandlerContext var1, Channel var2, Object var3) throws Exception;

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, Object var3) throws Exception;
}

