/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.AbstractNodeAddressResolver;
import co.paralleluniverse.galaxy.cluster.NodeInfo;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketNodeAddressResolver
extends AbstractNodeAddressResolver<InetSocketAddress> {
    private static final Logger LOG = LoggerFactory.getLogger(SocketNodeAddressResolver.class);
    private final String portProperty;

    public SocketNodeAddressResolver(Cluster cluster, String portProperty) {
        super(cluster);
        this.portProperty = portProperty;
        this.init();
    }

    @Override
    protected InetSocketAddress getAddress(NodeInfo node) {
        InetAddress address = (InetAddress)node.get("ip_addr");
        Integer port = (Integer)node.get(this.portProperty);
        if (address == null || port == null) {
            if (address == null) {
                LOG.warn("Socket address (property {}) not set for node {}", (Object)"ip_addr", (Object)node);
            }
            if (port == null) {
                LOG.warn("Socket port (property {}) not set for node {}", (Object)this.portProperty, (Object)node);
            }
            return null;
        }
        InetSocketAddress socket = new InetSocketAddress(address, (int)port);
        return socket;
    }
}

