/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.netty.ChannelAttachedNodeResolver;
import co.paralleluniverse.galaxy.netty.ChannelMessageNodeResolver;
import co.paralleluniverse.galaxy.netty.LoggingHandler;
import co.paralleluniverse.galaxy.netty.MessageCodec;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.slf4j.Logger;

public class TcpMessagePipelineFactory
implements ChannelPipelineFactory {
    private final Logger logger;
    private final DefaultChannelGroup channelGroup;
    private final ChannelMessageNodeResolver nodeResolver;
    private final int lengthFieldSize;
    private final Executor executor;

    public TcpMessagePipelineFactory(Logger logger, DefaultChannelGroup channelGroup, Executor executor) {
        this.logger = logger;
        this.channelGroup = channelGroup;
        this.nodeResolver = new ChannelAttachedNodeResolver();
        this.lengthFieldSize = 4;
        this.executor = executor;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder((int)((1L << this.lengthFieldSize * 8) - 1L) & Integer.MAX_VALUE, 0, this.lengthFieldSize, 0, this.lengthFieldSize));
        pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(this.lengthFieldSize, false));
        if (this.executor != null) {
            pipeline.addLast("executor", (ChannelHandler)new ExecutionHandler(this.executor));
        }
        pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.logger));
        pipeline.addLast("messageCodec", (ChannelHandler)new MessageCodec());
        pipeline.addLast("nodeResolver", (ChannelHandler)this.nodeResolver);
        pipeline.addLast("common", (ChannelHandler)new SimpleChannelUpstreamHandler(){

            public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                if (TcpMessagePipelineFactory.this.channelGroup != null) {
                    TcpMessagePipelineFactory.this.channelGroup.add(e.getChannel());
                }
                super.channelConnected(ctx, e);
            }

            public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                if (TcpMessagePipelineFactory.this.channelGroup != null) {
                    TcpMessagePipelineFactory.this.channelGroup.remove((Object)e.getChannel());
                }
                super.channelDisconnected(ctx, e);
                e.getChannel().close();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
                e.getChannel().close();
                super.exceptionCaught(ctx, e);
            }
        });
        return pipeline;
    }
}

