/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.cluster.NodeInfo;
import co.paralleluniverse.galaxy.cluster.ReaderWriters;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.MessageReceiver;
import co.paralleluniverse.galaxy.core.ServerComm;
import co.paralleluniverse.galaxy.netty.AbstractTcpClient;
import co.paralleluniverse.galaxy.netty.IpConstants;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpServerClientComm
extends AbstractTcpClient
implements ServerComm {
    private static final Logger LOG = LoggerFactory.getLogger(TcpServerClientComm.class);
    private MessageReceiver receiver;

    @ConstructorProperties(value={"name", "cluster"})
    public TcpServerClientComm(String name, Cluster cluster) throws Exception {
        super(name, cluster, "ip_server_port");
        cluster.addNodeProperty("ip_addr", true, true, IpConstants.INET_ADDRESS_READER_WRITER);
        cluster.setNodeProperty("ip_addr", InetAddress.getLocalHost());
        cluster.addNodeProperty("ip_server_port", false, true, ReaderWriters.INTEGER);
        cluster.addNodeChangeListener(new NodeChangeListener(){

            @Override
            public void nodeAdded(short id) {
                if (TcpServerClientComm.this.getCluster().isMaster() && id == 0) {
                    LOG.info("Server added! Connecting.");
                    TcpServerClientComm.this.setNodeName(TcpServerClientComm.this.getCluster().getMaster((short)0).getName());
                    TcpServerClientComm.this.connectLater();
                }
            }

            @Override
            public void nodeSwitched(short id) {
                if (TcpServerClientComm.this.getCluster().isMaster() && id == 0) {
                    LOG.info("Server switched! Reconnecting.");
                    TcpServerClientComm.this.reconnect(TcpServerClientComm.this.getCluster().getMaster((short)0).getName());
                }
            }

            @Override
            public void nodeRemoved(short id) {
                if (TcpServerClientComm.this.getCluster().isMaster() && id == 0) {
                    LOG.info("Server removed! Disconnecting.");
                    TcpServerClientComm.this.disconnect();
                    TcpServerClientComm.this.setNodeName(null);
                }
            }
        });
    }

    @Override
    protected void start(boolean master) {
        NodeInfo serverInfo;
        if (master && (serverInfo = this.getCluster().getMaster((short)0)) != null) {
            LOG.info("Came online and server found. Connecting.");
            this.reconnect(serverInfo.getName());
        }
    }

    @Override
    public void switchToMaster() {
        super.switchToMaster();
        this.reconnect(this.getCluster().getMaster((short)0).getName());
    }

    @Override
    public void setReceiver(MessageReceiver receiver) {
        this.assertDuringInitialization();
        this.receiver = receiver;
    }

    @Override
    protected void receive(ChannelHandlerContext ctx, Message message) {
        this.receiver.receive(message);
    }
}

