/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.cluster.NodeInfo;
import co.paralleluniverse.galaxy.cluster.ReaderWriters;
import co.paralleluniverse.galaxy.cluster.SlaveConfigurationListener;
import co.paralleluniverse.galaxy.core.Backup;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.netty.AbstractTcpClient;
import co.paralleluniverse.galaxy.netty.IpConstants;
import java.beans.ConstructorProperties;
import java.net.InetAddress;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpSlaveClientComm
extends AbstractTcpClient {
    private static final Logger LOG = LoggerFactory.getLogger(TcpSlaveClientComm.class);
    private Backup backup;
    private final SlaveConfigurationListener scListener = new SlaveConfigurationListener(){

        @Override
        public void newMaster(NodeInfo node) {
            if (!node.equals(TcpSlaveClientComm.this.getCluster().getMyNodeInfo())) {
                LOG.info("New master ({})! Reconnecting.", (Object)node.getName());
                TcpSlaveClientComm.this.reconnect(node.getName());
            } else {
                LOG.debug("It appears I'm the new master, and switchToMaster should come soo. Not connecting to myself");
            }
        }

        @Override
        public void slaveAdded(NodeInfo node) {
        }

        @Override
        public void slaveRemoved(NodeInfo node) {
        }
    };

    @ConstructorProperties(value={"name", "cluster"})
    public TcpSlaveClientComm(String name, Cluster cluster) throws Exception {
        super(name, cluster, "ip_slave_port");
        cluster.addNodeProperty("ip_addr", true, true, IpConstants.INET_ADDRESS_READER_WRITER);
        cluster.setNodeProperty("ip_addr", InetAddress.getLocalHost());
        cluster.addNodeProperty("ip_slave_port", true, false, ReaderWriters.INTEGER);
        cluster.addSlaveConfigurationListener(this.scListener);
    }

    @Override
    protected void postInit() throws Exception {
        super.postInit();
    }

    @Override
    protected void init() throws Exception {
        super.init();
    }

    @Override
    protected void available(boolean value) {
        super.available(value);
    }

    @Override
    public void joinedCluster() {
        super.joinedCluster();
        NodeInfo master = this.getCluster().getMaster(this.getCluster().getMyNodeId());
        if (master != null) {
            LOG.info("Connecting to master node {}", (Object)master.getName());
            this.reconnect(master.getName());
        }
    }

    @Override
    protected void start(boolean master) {
        if (master) {
            LOG.info("Master node. Shutting down slave client.");
            this.shutdown();
            return;
        }
        String myMaster = this.getCluster().getMyMaster().getName();
        assert (myMaster != null);
        if (!myMaster.equals(this.getNodeName())) {
            LOG.info("Re-connecting to master node {}", (Object)myMaster);
            this.reconnect(myMaster);
        }
    }

    @Override
    public void shutdown() {
        this.getCluster().removeSlaveConfigurationListener(this.scListener);
        super.shutdown();
    }

    @Override
    public void switchToMaster() {
        super.switchToMaster();
        LOG.info("Switched to master. Shutting down slave client.");
        this.shutdown();
    }

    public void setBackup(Backup backup) {
        this.assertDuringInitialization();
        this.backup = backup;
    }

    @Override
    protected void receive(ChannelHandlerContext ctx, Message message) {
        this.backup.receive(message);
    }
}

