/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.core.Backup;
import co.paralleluniverse.galaxy.core.ClusterService;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.NodeNotFoundException;
import co.paralleluniverse.galaxy.core.SlaveComm;
import co.paralleluniverse.galaxy.netty.TcpSlaveClientComm;
import co.paralleluniverse.galaxy.netty.TcpSlaveServerComm;
import java.beans.ConstructorProperties;
import java.util.concurrent.ThreadPoolExecutor;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;

public class TcpSlaveComm
extends ClusterService
implements SlaveComm {
    private static final Logger LOG = LoggerFactory.getLogger(TcpSlaveComm.class);
    private final TcpSlaveClientComm client;
    private final TcpSlaveServerComm server;

    @ConstructorProperties(value={"name", "cluster", "port"})
    TcpSlaveComm(String name, Cluster cluster, int port) throws Exception {
        super(name, cluster);
        this.server = new TcpSlaveServerComm(name + "Server", cluster, port);
        this.client = new TcpSlaveClientComm(name + "Client", cluster);
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.server.init();
        this.client.init();
    }

    @ManagedAttribute
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    protected void postInit() throws Exception {
        this.server.postInit();
        this.client.postInit();
        this.setReady(true);
        super.postInit();
    }

    @Override
    protected void available(boolean value) {
        super.available(value);
        this.server.available(value);
        this.client.available(value);
    }

    @Override
    public void setBackup(Backup backup) {
        this.server.setBackup(backup);
        this.client.setBackup(backup);
    }

    public void setBossExecutor(ThreadPoolExecutor executor) {
        this.assertDuringInitialization();
        this.server.setBossExecutor(executor);
        this.client.setBossExecutor(executor);
    }

    public void setWorkerExecutor(ThreadPoolExecutor executor) {
        this.assertDuringInitialization();
        this.server.setWorkerExecutor(executor);
        this.client.setWorkerExecutor(executor);
    }

    public void setReceiveExecutor(OrderedMemoryAwareThreadPoolExecutor executor) {
        this.assertDuringInitialization();
        this.server.setReceiveExecutor(executor);
        this.client.setReceiveExecutor(executor);
    }

    @Override
    protected void start(boolean master) {
    }

    @Override
    public boolean send(Message message) throws NodeNotFoundException {
        switch (message.getType()) {
            case BACKUP_PACKET: {
                if (!this.getCluster().isMaster()) {
                    LOG.warn("Backup message sent while slave: {}", (Object)message);
                    return false;
                }
                return this.server.send(message);
            }
            case BACKUP_PACKETACK: {
                if (this.getCluster().isMaster()) {
                    LOG.warn("Backup ack message sent while master: {}", (Object)message);
                    return false;
                }
                this.client.send(message);
                break;
            }
            case INV: {
                if (!this.getCluster().isMaster()) {
                    LOG.warn("Invalidate message sent while slave: {}", (Object)message);
                    return false;
                }
                return this.server.send(message);
            }
            case INVACK: {
                if (this.getCluster().isMaster()) {
                    LOG.warn("Invalidate ack message sent while master: {}", (Object)message);
                    return false;
                }
                this.client.send(message);
                break;
            }
            default: {
                LOG.warn("Unrecognized message: {}", (Object)message);
            }
        }
        return false;
    }
}

