/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.common.monitoring.Monitor;
import co.paralleluniverse.galaxy.netty.UDPComm;
import co.paralleluniverse.galaxy.netty.UDPCommMXBean;
import java.util.HashMap;
import java.util.Map;

class UDPCommMonitor
extends Monitor<UDPComm>
implements UDPCommMXBean {
    public UDPCommMonitor(String name, UDPComm monitored) {
        super("co.paralleluniverse.galaxy.netty:type=UDPComm,name=" + name, monitored);
    }

    @Override
    public int getBroadcastQueueLength() {
        UDPComm comm = (UDPComm)this.getMonitored();
        if (comm == null) {
            return -1;
        }
        return comm.getBroadcastPeer().getQueueLength();
    }

    @Override
    public Map<Short, Integer> getPeerQueuesLengths() {
        UDPComm comm = (UDPComm)this.getMonitored();
        if (comm == null) {
            return null;
        }
        HashMap<Short, Integer> lengths = new HashMap<Short, Integer>(comm.getPeers().size());
        for (Map.Entry entry : comm.getPeers().entrySet()) {
            lengths.put((Short)entry.getKey(), ((UDPComm.NodePeer)entry.getValue()).getQueueLength());
        }
        return lengths;
    }
}

