/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.netty;

import co.paralleluniverse.galaxy.netty.ChannelMessageNodeResolver;
import co.paralleluniverse.galaxy.netty.ChannelNodeAddressResolver;
import co.paralleluniverse.galaxy.netty.LoggingHandler;
import co.paralleluniverse.galaxy.netty.MessagePacketCodec;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.slf4j.Logger;

class UdpMessagePipelineFactory
implements ChannelPipelineFactory {
    private final Logger logger;
    private final ChannelMessageNodeResolver nodeResolver;
    private final Executor executor;

    public UdpMessagePipelineFactory(Logger logger, ChannelNodeAddressResolver nodeResolver, Executor executor) {
        this.logger = logger;
        this.nodeResolver = nodeResolver;
        this.executor = executor;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.executor != null) {
            pipeline.addLast("executor", (ChannelHandler)new ExecutionHandler(this.executor));
        }
        pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(this.logger));
        pipeline.addLast("messageCodec", (ChannelHandler)new MessagePacketCodec());
        pipeline.addLast("nodeResolver", (ChannelHandler)this.nodeResolver);
        return pipeline;
    }
}

