/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.objects;

import co.paralleluniverse.common.io.ByteBufferInputStream;
import co.paralleluniverse.common.io.Persistable;
import co.paralleluniverse.galaxy.Cache;
import co.paralleluniverse.galaxy.CacheListener;
import co.paralleluniverse.galaxy.Grid;
import co.paralleluniverse.galaxy.objects.DistributedReferenceStore;
import co.paralleluniverse.io.serialization.Serialization;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class DistributedReference<T>
implements CacheListener,
Persistable,
Serializable {
    private final long id;
    private volatile transient T obj;
    private volatile transient long version;
    private transient byte[] tmpBuffer;

    public DistributedReference(long id, T obj) {
        this.obj = obj;
        this.id = id;
        this.version = -1L;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Long.toHexString(this.id) + " (" + this.version + "): " + (this.obj != null ? this.obj.getClass().getName() + "@" + System.identityHashCode(this.obj) : "null") + "]";
    }

    public T get() {
        return this.obj;
    }

    public long getId() {
        return this.id;
    }

    protected void clear() {
        this.obj = null;
    }

    @Override
    public void invalidated(Cache cache, long id) {
    }

    @Override
    public void evicted(Cache cache, long id) {
        this.clear();
    }

    @Override
    public void killed(Cache cache, long id) {
    }

    @Override
    public void received(Cache cache, long id, long version, ByteBuffer data) {
        if (version > this.version) {
            this.read(data);
            this.version = version;
        }
    }

    @Override
    public int size() {
        return this.obj != null ? this.getSerialized().length : 0;
    }

    @Override
    public void write(ByteBuffer buffer) {
        if (this.obj != null) {
            buffer.put(this.getSerialized());
        }
        this.tmpBuffer = null;
    }

    byte[] getSerialized() {
        if (this.tmpBuffer == null) {
            this.tmpBuffer = this.serialize(this.obj);
        }
        return this.tmpBuffer;
    }

    @Override
    public void read(ByteBuffer buffer) {
        this.obj = this.deserialize(new ByteBufferInputStream(buffer));
    }

    @Override
    public void messageReceived(byte[] message) {
    }

    protected void set(T obj) {
        this.obj = obj;
    }

    protected byte[] serialize(T obj) {
        return obj != null ? Serialization.getInstance().write(obj) : null;
    }

    protected T deserialize(InputStream is) {
        try {
            return (T)Serialization.getInstance().read(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object writeReplace() {
        return new SerializedDistributedRef(this.id);
    }

    protected static class SerializedDistributedRef
    implements Serializable {
        final long id;

        public SerializedDistributedRef(long id) {
            this.id = id;
        }

        Object readResolve() {
            try {
                return DistributedReferenceStore.getOrCreateRef(Grid.getInstance().store(), this.id);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

