/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.objects;

import co.paralleluniverse.galaxy.Cache;
import co.paralleluniverse.galaxy.CacheListener;
import co.paralleluniverse.galaxy.objects.DistributedReference;

public class DistributedReferenceStore<R extends DistributedReference<T>, T> {
    private final Cache cache;

    public DistributedReferenceStore(Cache cache) {
        this.cache = cache;
    }

    public R newRef(long id, T obj) {
        if (id <= 0L) {
            return null;
        }
        assert (this.cache.getListener(id) == null);
        R ref = this.createRef(id, obj);
        this.cache.setListener(id, (CacheListener)ref);
        return ref;
    }

    public R getOrCreateRef(long id) {
        if (id <= 0L) {
            return null;
        }
        CacheListener ref = this.cache.getListener(id);
        return (R)((DistributedReference)(ref != null ? ref : this.cache.setListenerIfAbsent(id, (CacheListener)this.createRef(id, null))));
    }

    protected R createRef(long id, T obj) {
        return (R)new DistributedReference<T>(id, obj);
    }

    public static <T> DistributedReference<T> newRef(Cache cache, long id, T obj) {
        if (id <= 0L) {
            return null;
        }
        assert (cache.getListener(id) == null);
        DistributedReference<T> ref = new DistributedReference<T>(id, obj);
        cache.setListener(id, ref);
        return ref;
    }

    public static <T> DistributedReference<T> getOrCreateRef(Cache cache, long id) {
        if (id <= 0L) {
            return null;
        }
        CacheListener ref = cache.getListener(id);
        return (DistributedReference)(ref != null ? ref : cache.setListenerIfAbsent(id, new DistributedReference<Object>(id, null)));
    }
}

