/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.server;

import co.paralleluniverse.galaxy.core.Comm;
import co.paralleluniverse.galaxy.core.Message;
import co.paralleluniverse.galaxy.core.MessageReceiver;
import co.paralleluniverse.galaxy.core.ServerComm;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommPipe {
    private static final Logger LOG = LoggerFactory.getLogger(CommPipe.class);
    private final Executor queue = Executors.newSingleThreadExecutor();
    private MessageReceiver receiver1;
    private short node1;
    private MessageReceiver receiver2;
    private short node2 = 0;
    private final Comm comm1 = new ServerComm(){

        @Override
        public void setReceiver(MessageReceiver receiver) {
            CommPipe.this.receiver1 = receiver;
        }

        @Override
        public void send(Message message) {
            final Message m = message.clone();
            m.setNode(CommPipe.this.node1);
            m.setIncoming();
            CommPipe.this.queue.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("\"{}\" Received {}", (Object)CommPipe.this.node2, (Object)m);
                        }
                        CommPipe.this.receiver2.receive(m);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while processing message.", (Throwable)e);
                    }
                }
            });
        }
    };
    private final Comm comm2 = new Comm(){

        @Override
        public void setReceiver(MessageReceiver receiver) {
            CommPipe.this.receiver2 = receiver;
        }

        @Override
        public void send(Message message) {
            Message m = message.clone();
            m.setNode(CommPipe.this.node2);
            m.setIncoming();
            try {
                LOG.debug("Received {}", (Object)m);
                CommPipe.this.receiver1.receive(m);
            }
            catch (Exception e) {
                LOG.error("Exception while processing message.", (Throwable)e);
            }
        }
    };

    public synchronized Comm getComm1(short node1) {
        this.node1 = node1;
        return this.comm1;
    }

    public synchronized Comm getComm2(short node2) {
        this.node2 = node2;
        return this.comm2;
    }
}

