/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.server;

import co.paralleluniverse.galaxy.berkeleydb.BerkeleyDB;
import com.google.common.primitives.Longs;

public class MainMemoryEntry {
    public final long version;
    public final byte[] data;

    public MainMemoryEntry(long version, byte[] data) {
        this.version = version;
        this.data = data;
    }

    public MainMemoryEntry(byte[] buffer) {
        this.version = Longs.fromByteArray((byte[])buffer);
        this.data = new byte[buffer.length - 8];
        System.arraycopy(buffer, 8, this.data, 0, this.data.length);
    }

    public byte[] toByteArray() {
        byte[] buffer = new byte[8 + (this.data != null ? this.data.length : 0)];
        BerkeleyDB.toByteArray(this.version, buffer);
        if (this.data != null) {
            System.arraycopy(this.data, 0, buffer, 8, this.data.length);
        }
        return buffer;
    }
}

