/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.zookeeper;

import co.paralleluniverse.galaxy.cluster.DistributedTree;
import co.paralleluniverse.galaxy.cluster.DistributedTreeUtil;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.Pathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperDistributedTree
implements DistributedTree {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperDistributedTree.class);
    private final CuratorFramework client;
    private final Map<String, String> namesWithSequence = new ConcurrentHashMap<String, String>();
    private final Set<DistributedTree.Listener> removedListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Pattern ORDERED_NODE = Pattern.compile(".*:[0-9]{10}+\\z");

    public ZooKeeperDistributedTree(CuratorFramework client) {
        this.client = client;
    }

    @Override
    public void addListener(final String node, final DistributedTree.Listener listener) {
        try {
            LOG.info("Adding listener {} on {}", (Object)listener, (Object)this.possiblyWithSequence(node));
            MyWatcher watcher = new MyWatcher(listener, this.possiblyWithSequence(node));
            watcher.checkEphemeral();
            watcher.setChildren();
            ((BackgroundPathable)this.client.checkExists().usingWatcher((Watcher)watcher)).forPath(watcher.path);
            ((Pathable)this.client.getChildren().inBackground(new BackgroundCallback(){

                public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
                    List children = event.getChildren();
                    if (children != null) {
                        for (String child : children) {
                            listener.nodeChildAdded(ZooKeeperDistributedTree.nodeName(node), ZooKeeperDistributedTree.nodeName(child));
                        }
                    }
                }
            })).forPath(node);
        }
        catch (Exception ex) {
            LOG.error("Adding listener on node " + node + " has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public void removeListener(String node, DistributedTree.Listener listener) {
        LOG.info("Removing listener {}", (Object)listener);
        this.removedListeners.add(listener);
    }

    @Override
    public void create(String node, boolean ephemeral) {
        try {
            if (this.exists(node)) {
                LOG.info("Node {} already exists ({})", (Object)node, (Object)this.possiblyWithSequence(node));
                return;
            }
            LOG.info("Creating {} node {}", (Object)(ephemeral ? "ephemeral" : ""), (Object)node);
            if (ephemeral) {
                EphemeralChildren ec = null;
                String parent = DistributedTreeUtil.parent(node);
                if (!this.exists(parent)) {
                    ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(parent);
                } else {
                    ec = this.getEphemeralChildren(parent);
                }
                if (ec != null || ((Stat)this.client.checkExists().forPath(this.possiblyWithSequence(parent))).getEphemeralOwner() != 0L) {
                    if (ec == null) {
                        ec = new EphemeralChildren();
                    }
                    ec.createChild(DistributedTreeUtil.child(node));
                    this.client.setData().forPath(this.possiblyWithSequence(parent), ec.toByteArray());
                    LOG.info("Created ephemeral child node {} ({})", (Object)node, (Object)(this.possiblyWithSequence(parent) + '/' + DistributedTreeUtil.child(node)));
                    return;
                }
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(ephemeral ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT)).forPath(node);
        }
        catch (Exception ex) {
            LOG.error("Node " + node + " creation has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public void createEphemeralOrdered(String node) {
        try {
            LOG.info("Creating ephemeral ordered node {}", (Object)node);
            if (this.exists(node)) {
                LOG.info("Node {} already exists ({})", (Object)node, (Object)this.possiblyWithSequence(node));
                return;
            }
            String nameWithSequence = (String)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(node + ':');
            LOG.info("Created node {}", (Object)nameWithSequence);
            this.putOrdered(node, nameWithSequence);
        }
        catch (Exception ex) {
            LOG.error("Node " + node + " creation has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public boolean exists(String node) {
        try {
            EphemeralChildren ec;
            boolean exists;
            Stat stat = (Stat)this.client.checkExists().forPath(this.possiblyWithSequence(node));
            boolean bl = exists = stat != null;
            if (!exists && (ec = this.getEphemeralChildren(DistributedTreeUtil.parent(node))) != null) {
                return ec.hasChild(DistributedTreeUtil.child(node));
            }
            return exists;
        }
        catch (Exception ex) {
            LOG.error("Node " + node + " checkExists has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public void set(String node, byte[] data) {
        try {
            LOG.info("Setting node {} ({})", (Object)node, (Object)this.possiblyWithSequence(node));
            this.client.setData().forPath(this.possiblyWithSequence(node), data);
        }
        catch (Exception ex) {
            EphemeralChildren ec = this.getEphemeralChildren(DistributedTreeUtil.parent(node));
            if (ec != null) {
                try {
                    LOG.info("in set ec is {}", (Object)ec);
                    ec.setChildData(DistributedTreeUtil.child(node), data);
                    this.client.setData().forPath(this.possiblyWithSequence(DistributedTreeUtil.parent(node)), ec.toByteArray());
                    LOG.info("in set ec is {}", (Object)ec);
                    return;
                }
                catch (Exception e) {
                    ex = e;
                }
            }
            LOG.error("Node " + node + " setData has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public byte[] get(String node) {
        try {
            return (byte[])this.client.getData().forPath(this.possiblyWithSequence(node));
        }
        catch (Exception ex) {
            EphemeralChildren ec = this.getEphemeralChildren(DistributedTreeUtil.parent(node));
            if (ec != null) {
                return ec.getChildData(DistributedTreeUtil.child(node));
            }
            LOG.error("Node " + node + " getData has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public void delete(String node) {
        try {
            LOG.info("Deleting node {} ({})", (Object)node, (Object)this.possiblyWithSequence(node));
            for (String child : this.getChildren1(node)) {
                this.delete(DistributedTreeUtil.correctForRoot(node) + '/' + child);
            }
            this.client.delete().guaranteed().forPath(this.possiblyWithSequence(node));
            this.removeOrdered(node);
        }
        catch (Exception ex) {
            EphemeralChildren ec = this.getEphemeralChildren(DistributedTreeUtil.parent(node));
            if (ec != null) {
                try {
                    ec.deleteChild(DistributedTreeUtil.child(node));
                    this.client.setData().forPath(this.possiblyWithSequence(DistributedTreeUtil.parent(node)), ec.toByteArray());
                    return;
                }
                catch (Exception e) {
                    ex = e;
                }
            }
            LOG.error("Node " + node + " delete has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private List<String> getChildren1(String node) throws Exception {
        EphemeralChildren ec;
        List unordered = (List)this.client.getChildren().forPath(this.possiblyWithSequence(node));
        if ((unordered == null || unordered.isEmpty()) && (ec = this.getEphemeralChildren(node)) != null) {
            return ec.getChildren();
        }
        return this.orderedChildren(node, unordered);
    }

    @Override
    public List<String> getChildren(String node) {
        try {
            return this.getChildren1(node);
        }
        catch (Exception ex) {
            LOG.error("Node " + node + " getChildren has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void print(String node, PrintStream out) {
        this.print(node, out, 0);
        out.print('\n');
    }

    private void print(String node, PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(' ');
        }
        String name = DistributedTreeUtil.child(node);
        out.append('/').append(name != null ? name : "");
        try {
            for (String child : this.getChildren1(node)) {
                out.print('\n');
                this.print(DistributedTreeUtil.correctForRoot(node) + '/' + child, out, indent + 4);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private List<String> orderedChildren(String parent, List<String> unordered) {
        TreeMap<Long, String> sm = new TreeMap<Long, String>();
        ArrayList<String> ordered = new ArrayList<String>(unordered.size());
        for (String child : unordered) {
            if (ZooKeeperDistributedTree.isOrdered(child)) {
                String name = ZooKeeperDistributedTree.getName(child);
                sm.put(ZooKeeperDistributedTree.getSequence(child), name);
                this.putOrdered(parent + '/' + name, parent + '/' + child);
                continue;
            }
            ordered.add(child);
        }
        for (String child : sm.values()) {
            ordered.add(child);
        }
        return ordered;
    }

    private String possiblyWithSequence(String node) {
        String nodeWithSequence = this.namesWithSequence.get(node);
        return nodeWithSequence != null ? nodeWithSequence : node;
    }

    private void rememberIfOrdered(String node) {
        if (ZooKeeperDistributedTree.isOrdered(node)) {
            this.putOrdered(ZooKeeperDistributedTree.getName(node), node);
        }
    }

    private void putOrdered(String node, String nodeWithSeq) {
        LOG.debug("Putting sequenced node: {} = {}", (Object)node, (Object)nodeWithSeq);
        this.namesWithSequence.put(node, nodeWithSeq);
    }

    private void removeOrdered(String node) {
        LOG.debug("Removing sequenced node: {}", (Object)node);
        this.namesWithSequence.remove(node);
    }

    private static String nodeName(String node) {
        return ZooKeeperDistributedTree.isOrdered(node) ? ZooKeeperDistributedTree.getName(node) : node;
    }

    private static boolean isOrdered(String node) {
        if (node == null) {
            return false;
        }
        return ORDERED_NODE.matcher(node).matches();
    }

    private static String getName(String node) {
        return node.substring(0, node.lastIndexOf(58));
    }

    private static long getSequence(String node) {
        return Long.parseLong(node.substring(node.lastIndexOf(58) + 1));
    }

    private EphemeralChildren getEphemeralChildren(String node) {
        try {
            if (node == null || node.isEmpty() || node.equals("/")) {
                return null;
            }
            node = this.possiblyWithSequence(node);
            Stat stat = (Stat)this.client.checkExists().forPath(node);
            if (stat == null) {
                return null;
            }
            if (stat.getEphemeralOwner() == 0L) {
                return null;
            }
            byte[] buffer = (byte[])this.client.getData().forPath(node);
            if (buffer == null || buffer.length == 0) {
                return null;
            }
            return new EphemeralChildren(buffer);
        }
        catch (Exception ex) {
            LOG.error("Node " + node + " op has failed!", (Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private static final class EphemeralChildren {
        private byte[] data;
        private Map<String, byte[]> children;

        public EphemeralChildren() {
        }

        public EphemeralChildren(byte[] buffer) {
            this.fromByteArray(buffer);
        }

        public synchronized void setData(byte[] data) {
            this.data = (byte[])(data == null ? null : Arrays.copyOf(data, data.length));
        }

        public synchronized byte[] getData() {
            return this.data != null ? Arrays.copyOf(this.data, this.data.length) : null;
        }

        public synchronized boolean hasChild(String child) {
            if (this.children == null) {
                return false;
            }
            return this.children.containsKey(child);
        }

        public synchronized void createChild(String child) {
            if (this.children == null) {
                this.children = new HashMap<String, byte[]>();
            }
            this.children.put(child, null);
        }

        public synchronized void deleteChild(String child) {
            if (this.children == null) {
                return;
            }
            this.children.remove(child);
        }

        public synchronized void setChildData(String child, byte[] data) {
            if (this.children == null) {
                this.children = new HashMap<String, byte[]>();
            }
            this.children.put(child, data != null ? Arrays.copyOf(data, data.length) : null);
        }

        public synchronized byte[] getChildData(String child) {
            if (this.children == null || !this.children.containsKey(child)) {
                throw new RuntimeException("Child " + child + " does not exist!");
            }
            byte[] d = this.children.get(child);
            return d != null ? Arrays.copyOf(d, d.length) : null;
        }

        public synchronized List<String> getChildren() {
            return this.children != null ? new ArrayList<String>(this.children.keySet()) : null;
        }

        public synchronized Map<String, byte[]> getChildrenData() {
            return this.children != null ? this.children : Collections.emptyMap();
        }

        public String toString() {
            return "EphemeralChildren{children=" + this.children.keySet() + '}';
        }

        public synchronized byte[] toByteArray() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                if (this.data == null) {
                    oos.writeInt(-1);
                } else {
                    oos.writeShort(this.data.length);
                    oos.write(this.data);
                }
                oos.writeObject(this.children);
                oos.flush();
                baos.flush();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        public synchronized void fromByteArray(byte[] array) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(array));
                int dataLen = ois.readInt();
                if (dataLen == -1) {
                    this.data = null;
                } else {
                    this.data = new byte[dataLen];
                    ois.readFully(this.data);
                }
                this.children = (Map)ois.readObject();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private class MyWatcher
    implements Watcher {
        public final DistributedTree.Listener listener;
        public final String path;
        private List<String> children = Collections.emptyList();
        private EphemeralChildren ephemeralChildren = null;
        private boolean ephemeral;
        private boolean created;
        private final Watcher childrenWatcher = new Watcher(){

            public void process(WatchedEvent event) {
                try {
                    if (event.getPath() != null && !ZooKeeperDistributedTree.this.removedListeners.remove(MyWatcher.this.listener)) {
                        if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
                            assert (MyWatcher.this.path.equals(DistributedTreeUtil.parent(event.getPath())));
                            LOG.info("Node child data changed: {} ({})", (Object)ZooKeeperDistributedTree.nodeName(event.getPath()), (Object)event.getPath());
                            MyWatcher.this.listener.nodeChildUpdated(MyWatcher.this.path, DistributedTreeUtil.child(ZooKeeperDistributedTree.nodeName(event.getPath())));
                        }
                        ((BackgroundPathable)ZooKeeperDistributedTree.this.client.checkExists().usingWatcher((Watcher)this)).forPath(event.getPath());
                    }
                }
                catch (Exception ex) {
                    LOG.error("Exception:", (Throwable)ex);
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        };

        public MyWatcher(DistributedTree.Listener listener, String path) {
            this.listener = listener;
            this.path = path;
        }

        public void setChildren() {
            try {
                List cs = null;
                if (this.ephemeral) {
                    this.ephemeralChildren = ZooKeeperDistributedTree.this.getEphemeralChildren(this.path);
                    if (this.ephemeralChildren != null) {
                        cs = this.ephemeralChildren.getChildren();
                    }
                } else if (ZooKeeperDistributedTree.this.client.checkExists().forPath(this.path) != null) {
                    cs = (List)((BackgroundPathable)ZooKeeperDistributedTree.this.client.getChildren().usingWatcher((Watcher)this)).forPath(this.path);
                }
                if (cs == null) {
                    return;
                }
                this.children = new ArrayList<String>(cs);
                Collections.sort(this.children);
                for (String child : this.children) {
                    try {
                        ((BackgroundPathable)ZooKeeperDistributedTree.this.client.checkExists().usingWatcher(this.childrenWatcher)).forPath(DistributedTreeUtil.correctForRoot(this.path) + '/' + child);
                    }
                    catch (Exception ex) {
                        LOG.error("Node checkExists has failed!", (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Node checkExists has failed!", (Throwable)ex);
                throw Throwables.propagate((Throwable)ex);
            }
        }

        public void checkEphemeral() {
            try {
                Stat stat;
                if (!this.created && (stat = (Stat)((BackgroundPathable)ZooKeeperDistributedTree.this.client.checkExists().usingWatcher((Watcher)this)).forPath(this.path)) != null) {
                    this.ephemeral = stat.getEphemeralOwner() != 0L;
                    this.created = true;
                }
            }
            catch (Exception ex) {
                LOG.error("Exception:", (Throwable)ex);
                throw Throwables.propagate((Throwable)ex);
            }
        }

        public void process(WatchedEvent event) {
            block23: {
                try {
                    LOG.debug("ZooKeeper event: {}", (Object)event);
                    if (ZooKeeperDistributedTree.this.removedListeners.remove(this.listener)) break block23;
                    String node = ZooKeeperDistributedTree.nodeName(event.getPath());
                    switch (event.getType()) {
                        case NodeCreated: {
                            LOG.info("Node created: {} ({})", (Object)node, (Object)event.getPath());
                            ZooKeeperDistributedTree.this.rememberIfOrdered(event.getPath());
                            this.listener.nodeAdded(node);
                            this.checkEphemeral();
                            if (((BackgroundPathable)ZooKeeperDistributedTree.this.client.checkExists().usingWatcher((Watcher)this)).forPath(event.getPath()) == null) break;
                            ((BackgroundPathable)ZooKeeperDistributedTree.this.client.getChildren().usingWatcher((Watcher)this)).forPath(event.getPath());
                            break;
                        }
                        case NodeDataChanged: {
                            ((BackgroundPathable)ZooKeeperDistributedTree.this.client.checkExists().usingWatcher((Watcher)this)).forPath(event.getPath());
                            LOG.info("Node data changed: {} ({})", (Object)node, (Object)event.getPath());
                            if (this.ephemeral) {
                                EphemeralChildren ec = ZooKeeperDistributedTree.this.getEphemeralChildren(event.getPath());
                                if (ec != null) {
                                    this.processChildrenChanged(event, node, ec.getChildren());
                                    if (this.ephemeralChildren != null) {
                                        for (Map.Entry<String, byte[]> entry : this.ephemeralChildren.getChildrenData().entrySet()) {
                                            if (!ec.hasChild(entry.getKey()) || Arrays.equals(entry.getValue(), ec.getChildData(entry.getKey()))) continue;
                                            this.listener.nodeChildUpdated(node, entry.getKey());
                                        }
                                        this.listener.nodeUpdated(node);
                                    } else if (ec.getData() != null) {
                                        this.listener.nodeUpdated(node);
                                    }
                                } else if (this.ephemeralChildren != null) {
                                    this.processChildrenChanged(event, node, new ArrayList<String>());
                                    if (this.ephemeralChildren.getData() != null) {
                                        this.listener.nodeUpdated(node);
                                    }
                                }
                                this.ephemeralChildren = ec;
                                break;
                            }
                            this.listener.nodeUpdated(node);
                            break;
                        }
                        case NodeDeleted: {
                            LOG.info("Node deleted: {} ({})", (Object)node, (Object)event.getPath());
                            this.listener.nodeDeleted(node);
                            ZooKeeperDistributedTree.this.removeOrdered(node);
                            this.created = false;
                            break;
                        }
                        case NodeChildrenChanged: {
                            LOG.info("Node children changed: {} ({})", (Object)node, (Object)event.getPath());
                            List<String> newChildren = Collections.emptyList();
                            try {
                                newChildren = new ArrayList<String>((Collection)((BackgroundPathable)ZooKeeperDistributedTree.this.client.getChildren().usingWatcher((Watcher)this)).forPath(event.getPath()));
                            }
                            catch (KeeperException.NoNodeException e) {
                                // empty catch block
                            }
                            this.processChildrenChanged(event, node, newChildren);
                            break;
                        }
                        case None: {
                            try {
                                if (event.getPath() != null && ((BackgroundPathable)ZooKeeperDistributedTree.this.client.checkExists().usingWatcher((Watcher)this)).forPath(event.getPath()) != null) {
                                    ((BackgroundPathable)ZooKeeperDistributedTree.this.client.getChildren().usingWatcher((Watcher)this)).forPath(event.getPath());
                                }
                                break;
                            }
                            catch (KeeperException.NoNodeException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error("Exception:", (Throwable)ex);
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        }

        private void processChildrenChanged(WatchedEvent event, String node, List<String> newChildren) throws Exception {
            Collections.sort(newChildren);
            LOG.debug("processChildrenChanged: old: {} new: {}", this.children, newChildren);
            int i = 0;
            int j = 0;
            while (i < this.children.size() || j < newChildren.size()) {
                String n;
                String o = i < this.children.size() ? this.children.get(i) : null;
                String string = n = j < newChildren.size() ? newChildren.get(j) : null;
                int c = o == null && n == null ? 0 : (o == null ? 1 : (n == null ? -1 : o.compareTo(n)));
                if (c == 0) {
                    ++i;
                    ++j;
                    continue;
                }
                if (c > 0) {
                    LOG.info("Node child added: {} {} (" + n + ")", (Object)ZooKeeperDistributedTree.nodeName(n), (Object)this.path);
                    ZooKeeperDistributedTree.this.rememberIfOrdered(event.getPath() + '/' + n);
                    this.listener.nodeChildAdded(node, ZooKeeperDistributedTree.nodeName(n));
                    if (!this.ephemeral) {
                        ((BackgroundPathable)ZooKeeperDistributedTree.this.client.checkExists().usingWatcher(this.childrenWatcher)).forPath(DistributedTreeUtil.correctForRoot(event.getPath()) + '/' + n);
                    }
                    ++j;
                    continue;
                }
                LOG.info("Node child deleted: {} ({})", (Object)ZooKeeperDistributedTree.nodeName(o), (Object)o);
                this.listener.nodeChildDeleted(node, ZooKeeperDistributedTree.nodeName(o));
                ZooKeeperDistributedTree.this.removeOrdered(DistributedTreeUtil.correctForRoot(node) + '/' + ZooKeeperDistributedTree.nodeName(o));
                ++i;
            }
            this.children = newChildren;
        }
    }
}

