/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization;

import co.paralleluniverse.io.serialization.ByteArraySerializer;
import co.paralleluniverse.io.serialization.IOStreamSerializer;
import co.paralleluniverse.io.serialization.JDKSerializer;
import co.paralleluniverse.io.serialization.kryo.KryoSerializer;
import com.esotericsoftware.kryo.Kryo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Serialization {
    private static final boolean useJDKSerialization = Boolean.getBoolean("co.paralleluniverse.io.useJDKSerialization");
    private static final Serialization instance = useJDKSerialization ? new Serialization(new JDKSerializer()) : null;
    private static final ThreadLocal<Serialization> tlInstance = new ThreadLocal<Serialization>(){

        @Override
        protected Serialization initialValue() {
            return new Serialization(new KryoSerializer());
        }
    };
    private final ByteArraySerializer bas;
    private final IOStreamSerializer ioss;

    public static Serialization getInstance() {
        if (instance != null) {
            return instance;
        }
        return tlInstance.get();
    }

    public static Serialization newInstance() {
        if (instance != null) {
            return instance;
        }
        return new Serialization(new KryoSerializer());
    }

    public static Kryo getKryo() {
        return ((KryoSerializer)Serialization.tlInstance.get().bas).getKryo();
    }

    private Serialization(ByteArraySerializer bas) {
        this.bas = bas;
        this.ioss = (IOStreamSerializer)((Object)bas);
    }

    public Object read(byte[] buf) {
        return this.read(buf, 0);
    }

    public Object read(byte[] buf, int offset) {
        return this.bas.read(buf, offset);
    }

    public byte[] write(Object object) {
        return this.bas.write(object);
    }

    public Object read(InputStream is) throws IOException {
        return this.ioss.read(is);
    }

    public void write(OutputStream os, Object object) throws IOException {
        this.ioss.write(os, object);
    }
}

