/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.DirectoryFiller;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jnr.ffi.Pointer;
import jnr.ffi.annotations.Delegate;
import jnr.ffi.types.off_t;

final class DirectoryFillerImpl
implements DirectoryFiller {
    private static final String currentDirectory = ".";
    private static final String parentDirectory = "..";
    private final Pointer buf;
    private final fuse_fill_dir_t nativeFunction;
    private final Set<String> addedFiles = new HashSet<String>();

    DirectoryFillerImpl(Pointer buf, fuse_fill_dir_t nativeFunction) {
        this.buf = buf;
        this.nativeFunction = nativeFunction;
        this.add(Arrays.asList(currentDirectory, parentDirectory));
    }

    @Override
    public final boolean add(Iterable<String> files) {
        for (String file : files) {
            int result;
            if (file == null || !this.addedFiles.add(file = Paths.get(file, new String[0]).getFileName().toString()) || (result = this.nativeFunction.invoke(this.buf, ByteBuffer.wrap(file.getBytes()), null, 0L)) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        int count = 0;
        for (String file : this.addedFiles) {
            output.append(file);
            if (count < this.addedFiles.size() - 1) {
                output.append(", ");
            }
            ++count;
        }
        return output.toString();
    }

    public static interface fuse_fill_dir_t {
        @Delegate
        public int invoke(Pointer var1, ByteBuffer var2, Pointer var3, @off_t long var4);
    }
}

