/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.DirectoryFillerImpl;
import co.paralleluniverse.fuse.FuseFilesystem;
import co.paralleluniverse.fuse.JNRUtil;
import co.paralleluniverse.fuse.StructFlock;
import co.paralleluniverse.fuse.StructFuseBufvec;
import co.paralleluniverse.fuse.StructFuseFileInfo;
import co.paralleluniverse.fuse.StructFuseOperationsIfaces;
import co.paralleluniverse.fuse.StructFusePollHandle;
import co.paralleluniverse.fuse.StructStat;
import co.paralleluniverse.fuse.StructStatvfs;
import co.paralleluniverse.fuse.StructTimeBuffer;
import co.paralleluniverse.fuse.XattrFiller;
import co.paralleluniverse.fuse.XattrListFiller;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import jnr.ffi.Pointer;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.provider.jffi.ClosureHelper;
import jnr.ffi.types.dev_t;
import jnr.ffi.types.gid_t;
import jnr.ffi.types.mode_t;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import jnr.ffi.types.u_int32_t;
import jnr.ffi.types.uid_t;

class Filesystem
implements StructFuseOperationsIfaces._readlink,
StructFuseOperationsIfaces._mknod,
StructFuseOperationsIfaces._mkdir,
StructFuseOperationsIfaces._unlink,
StructFuseOperationsIfaces._rmdir,
StructFuseOperationsIfaces._symlink,
StructFuseOperationsIfaces._rename,
StructFuseOperationsIfaces._link,
StructFuseOperationsIfaces._chmod,
StructFuseOperationsIfaces._chown,
StructFuseOperationsIfaces._truncate,
StructFuseOperationsIfaces._open,
StructFuseOperationsIfaces._read,
StructFuseOperationsIfaces._write,
StructFuseOperationsIfaces._flush,
StructFuseOperationsIfaces._release,
StructFuseOperationsIfaces._fsync,
StructFuseOperationsIfaces._statfs,
StructFuseOperationsIfaces._lock,
StructFuseOperationsIfaces._getattr,
StructFuseOperationsIfaces._fgetattr,
StructFuseOperationsIfaces._setxattr_MAC,
StructFuseOperationsIfaces._setxattr_NOT_MAC,
StructFuseOperationsIfaces._getxattr_MAC,
StructFuseOperationsIfaces._getxattr_NOT_MAC,
StructFuseOperationsIfaces._listxattr,
StructFuseOperationsIfaces._removexattr,
StructFuseOperationsIfaces._opendir,
StructFuseOperationsIfaces._readdir,
StructFuseOperationsIfaces._releasedir,
StructFuseOperationsIfaces._fsyncdir,
StructFuseOperationsIfaces._init,
StructFuseOperationsIfaces._destroy,
StructFuseOperationsIfaces._access,
StructFuseOperationsIfaces._create,
StructFuseOperationsIfaces._ftruncate,
StructFuseOperationsIfaces._utimens,
StructFuseOperationsIfaces._bmap,
StructFuseOperationsIfaces._ioctl,
StructFuseOperationsIfaces._poll,
StructFuseOperationsIfaces._write_buf,
StructFuseOperationsIfaces._read_buf,
StructFuseOperationsIfaces._flock,
StructFuseOperationsIfaces._fallocate {
    private final FuseFilesystem fs;

    public Filesystem(FuseFilesystem fs) {
        this.fs = fs;
    }

    @Override
    public final int _getattr(String path, Pointer stat) {
        return this.fs.getattr(path, this.fs.defaultStat(new StructStat(stat, path)));
    }

    @Override
    public final int _readlink(String path, Pointer buffer, @size_t long size) {
        ByteBuffer buf = JNRUtil.toByteBuffer(buffer, size);
        int result = this.fs.readlink(path, buf, size);
        if (result == 0) {
            try {
                buf.put((byte)0);
            }
            catch (BufferOverflowException e) {
                ((ByteBuffer)buf.position(buf.limit() - 1)).put((byte)0);
            }
        }
        return result;
    }

    @Override
    public final int _mknod(String path, @mode_t long mode, @dev_t long dev) {
        return this.fs.mknod(path, mode, dev);
    }

    @Override
    public final int _mkdir(String path, @mode_t long mode) {
        return this.fs.mkdir(path, mode);
    }

    @Override
    public final int _unlink(String path) {
        return this.fs.unlink(path);
    }

    @Override
    public final int _rmdir(String path) {
        return this.fs.rmdir(path);
    }

    @Override
    public final int _symlink(String path, String target) {
        return this.fs.symlink(path, target);
    }

    @Override
    public final int _rename(String path, String newName) {
        return this.fs.rename(path, newName);
    }

    @Override
    public final int _link(String path, String target) {
        return this.fs.link(path, target);
    }

    @Override
    public final int _chmod(String path, @mode_t long mode) {
        return this.fs.chmod(path, mode);
    }

    @Override
    public final int _chown(String path, @uid_t long uid, @gid_t long gid) {
        return this.fs.chown(path, uid, gid);
    }

    @Override
    public final int _truncate(String path, @off_t long offset) {
        return this.fs.truncate(path, offset);
    }

    @Override
    public final int _open(String path, Pointer info) {
        return this.fs.open(path, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _read(String path, @Out Pointer buffer, @size_t long size, @off_t long offset, Pointer info) {
        ByteBuffer buf = JNRUtil.toByteBuffer(buffer, size);
        return this.fs.read(path, buf, size, offset, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _write(String path, @In Pointer buffer, @size_t long size, @off_t long offset, Pointer info) {
        ByteBuffer buf = JNRUtil.toByteBuffer(buffer, size);
        return this.fs.write(path, buf, size, offset, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _statfs(String path, Pointer statsvfs) {
        return this.fs.statfs(path, new StructStatvfs(statsvfs, path));
    }

    @Override
    public final int _flush(String path, Pointer info) {
        return this.fs.flush(path, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _release(String path, Pointer info) {
        return this.fs.release(path, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _fsync(String path, int datasync, @In Pointer info) {
        return this.fs.fsync(path, datasync, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _setxattr(String path, String xattr, Pointer value, @size_t long size, int flags) {
        return this._setxattr(path, xattr, value, size, flags, 0);
    }

    @Override
    public final int _setxattr(String path, String xattr, Pointer value, @size_t long size, int flags, int position) {
        ByteBuffer val = JNRUtil.toByteBuffer(value, size);
        return this.fs.setxattr(path, xattr, val, size, flags, position);
    }

    @Override
    public final int _getxattr(String path, String xattr, Pointer buffer, @size_t long size) {
        return this._getxattr(path, xattr, buffer, size, 0L);
    }

    @Override
    public final int _getxattr(String path, String xattr, Pointer buffer, @size_t long size, @u_int32_t long position) {
        XattrFiller filler = new XattrFiller(buffer == null ? null : JNRUtil.toByteBuffer(buffer, size), size, (int)position);
        int result = this.fs.getxattr(path, xattr, filler, size, position);
        return result < 0 ? result : (int)filler.getSize();
    }

    @Override
    public final int _listxattr(String path, Pointer buffer, @size_t long size) {
        XattrListFiller filler = new XattrListFiller(buffer == null ? null : JNRUtil.toByteBuffer(buffer, size), size);
        int result = this.fs.listxattr(path, filler);
        return result < 0 ? result : (int)filler.requiredSize();
    }

    @Override
    public final int _removexattr(String path, String xattr) {
        return this.fs.removexattr(path, xattr);
    }

    @Override
    public final int _opendir(String path, Pointer info) {
        return this.fs.opendir(path, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _readdir(String path, Pointer buf, Pointer fillFunction, @off_t long offset, @In Pointer info) {
        return this.fs.readdir(path, new StructFuseFileInfo(info, path), new DirectoryFillerImpl(buf, ClosureHelper.getInstance().fromNative(fillFunction, DirectoryFillerImpl.fuse_fill_dir_t.class)));
    }

    @Override
    public final int _releasedir(String path, Pointer info) {
        return this.fs.releasedir(path, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _fsyncdir(String path, int datasync, @In Pointer info) {
        return this.fs.fsyncdir(path, datasync, new StructFuseFileInfo(info, path));
    }

    @Override
    public final void _init(Pointer conn) {
        this.fs.init();
    }

    @Override
    public final void _destroy() {
        this.fs.destroy();
        this.fs._destroy();
    }

    @Override
    public final int _access(String path, int access) {
        return this.fs.access(path, access);
    }

    @Override
    public final int _create(String path, @mode_t long mode, Pointer info) {
        return this.fs.create(path, mode, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _ftruncate(String path, @off_t long offset, @In Pointer info) {
        return this.fs.ftruncate(path, offset, new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _fgetattr(String path, Pointer stat, Pointer info) {
        return this.fs.fgetattr(path, this.fs.defaultStat(new StructStat(stat, path)), new StructFuseFileInfo(info, path));
    }

    @Override
    public final int _lock(String path, Pointer info, int cmd, Pointer flock) {
        StructFuseFileInfo fileWrapper = new StructFuseFileInfo(info, path);
        StructFlock flockWrapper = new StructFlock(flock, path);
        int result = this.fs.lock(path, fileWrapper, cmd, flockWrapper);
        return result;
    }

    @Override
    public final int _utimens(String path, Pointer timebuffer) {
        return this.fs.utimens(path, new StructTimeBuffer(timebuffer));
    }

    @Override
    public final int _bmap(String path, Pointer info) {
        return this.fs.bmap(path, new StructFuseFileInfo(info, path));
    }

    @Override
    public void _ioctl(String path, int cmd, Pointer arg, Pointer fi, long flags, Pointer data) {
        this.fs.ioctl(path, cmd, arg, new StructFuseFileInfo(fi, path), flags, data);
    }

    @Override
    public void _poll(String path, Pointer fi, Pointer ph, Pointer reventsp) {
        this.fs.poll(path, new StructFuseFileInfo(fi, path), new StructFusePollHandle(ph), reventsp);
    }

    @Override
    public void _write_buf(String path, Pointer buf, long off, Pointer fi) {
        this.fs.write_buf(path, new StructFuseBufvec(buf), off, new StructFuseFileInfo(fi, path));
    }

    @Override
    public void _read_buf(String path, Pointer bufp, long size, long off, Pointer fi) {
        this.fs.read_buf(path, bufp, size, off, new StructFuseFileInfo(fi, path));
    }

    @Override
    public void _flock(String path, Pointer fi, int op) {
        this.fs.flock(path, new StructFuseFileInfo(fi, path), op);
    }

    @Override
    public void _fallocate(String path, int mode, long off, long length, Pointer fi) {
        this.fs.fallocate(path, mode, off, length, new StructFuseFileInfo(fi, path));
    }
}

