/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.FuseException;
import co.paralleluniverse.fuse.FuseFilesystem;
import co.paralleluniverse.fuse.LibFuse;
import co.paralleluniverse.fuse.LoggedFuseFilesystem;
import co.paralleluniverse.fuse.Platform;
import co.paralleluniverse.fuse.ProcessGobbler;
import co.paralleluniverse.fuse.StructFuseContext;
import co.paralleluniverse.fuse.StructFuseOperations;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import jnr.ffi.Struct;

public final class Fuse {
    private static LibFuse libFuse = null;
    private static long initTime;
    private static final Lock initLock;
    private static final Random defaultFilesystemRandom;
    private static final long errorSleepDuration = 750L;
    private static String fusermount;
    private static String umount;
    private static int currentUid;
    private static int currentGid;
    private static final ConcurrentMap<Path, FuseFilesystem> mountedFs;

    static void destroyed(FuseFilesystem fuseFilesystem) {
        if (Fuse.handleShutdownHooks()) {
            try {
                Runtime.getRuntime().removeShutdownHook(fuseFilesystem.getUnmountHook());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static StructFuseContext getFuseContext() {
        return Fuse.init().fuse_get_context();
    }

    static int getGid() {
        return currentGid;
    }

    static long getInitTime() {
        Fuse.init();
        return initTime;
    }

    static int getUid() {
        return currentUid;
    }

    private static boolean handleShutdownHooks() {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return true;
        }
        try {
            security.checkPermission(new RuntimePermission("shutdownHooks"));
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static LibFuse init() throws UnsatisfiedLinkError {
        if (libFuse != null) {
            return libFuse;
        }
        initLock.lock();
        try {
            if (libFuse == null) {
                libFuse = Platform.fuse();
                initTime = System.currentTimeMillis();
            }
            try {
                currentUid = Integer.parseInt(new ProcessGobbler("id", "-u").getStdout());
                currentGid = Integer.parseInt(new ProcessGobbler("id", "-g").getStdout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            LibFuse libFuse = Fuse.libFuse;
            return libFuse;
        }
        finally {
            initLock.unlock();
        }
    }

    public static void mount(FuseFilesystem filesystem, Path mountPoint, boolean blocking, boolean debug, Map<String, String> mountOptions) throws IOException {
        Integer result;
        String[] argv;
        if (!Files.isDirectory(mountPoint = mountPoint.toAbsolutePath().normalize().toRealPath(new LinkOption[0]), new LinkOption[0])) {
            throw new NotDirectoryException(mountPoint.toString());
        }
        if (!(Files.isReadable(mountPoint) && Files.isWritable(mountPoint) && Files.isExecutable(mountPoint))) {
            throw new AccessDeniedException(mountPoint.toString());
        }
        Logger logger = filesystem.getLogger();
        if (logger != null) {
            filesystem = new LoggedFuseFilesystem(filesystem, logger);
        }
        filesystem.mount(mountPoint, blocking);
        String filesystemName = filesystem.getFuseName();
        String[] options = Fuse.toOptionsArray(mountOptions);
        if (options == null) {
            argv = new String[debug ? 4 : 3];
        } else {
            argv = new String[(debug ? 4 : 3) + options.length];
            System.arraycopy(options, 0, argv, debug ? 3 : 2, options.length);
        }
        argv[0] = filesystemName;
        argv[1] = "-f";
        if (debug) {
            argv[2] = "-d";
        }
        argv[argv.length - 1] = mountPoint.toString();
        LibFuse fuse = Fuse.init();
        StructFuseOperations operations = new StructFuseOperations(jnr.ffi.Runtime.getRuntime((Object)fuse), filesystem);
        if (Fuse.handleShutdownHooks()) {
            Runtime.getRuntime().addShutdownHook(filesystem.getUnmountHook());
        }
        mountedFs.put(mountPoint, filesystem);
        if (blocking) {
            result = fuse.fuse_main_real(argv.length, argv, operations, Struct.size((Struct)operations), null);
        } else {
            MountThread mountThread = new MountThread(filesystemName, fuse, argv, mountPoint, operations);
            mountThread.start();
            try {
                mountThread.join(750L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            result = mountThread.getResult();
        }
        if (result != null && result != 0) {
            throw new FuseException(result);
        }
    }

    static void unmount(FuseFilesystem fuseFilesystem) throws IOException {
        fuseFilesystem.unmount();
        Path mountPoint = fuseFilesystem.getMountPoint();
        FuseFilesystem fs = (FuseFilesystem)mountedFs.remove(mountPoint);
        assert (fs == null || fs == fuseFilesystem);
        Fuse.unmount(mountPoint);
    }

    public static void setFusermount(String fusermount) {
        Fuse.fusermount = fusermount;
    }

    public static void setUmount(String umount) {
        Fuse.umount = umount;
    }

    public static void unmount(Path mountPoint) throws IOException {
        ProcessGobbler process;
        FuseFilesystem fs = (FuseFilesystem)mountedFs.get(mountPoint);
        if (fs != null) {
            Fuse.unmount(fs);
            return;
        }
        try {
            process = new ProcessGobbler(fusermount, "-z", "-u", mountPoint.toString());
        }
        catch (IOException e) {
            process = new ProcessGobbler(umount, mountPoint.toString());
        }
        int res = process.getReturnCode();
        if (res != 0) {
            throw new FuseException(res);
        }
    }

    private static String[] toOptionsArray(Map<String, String> options) {
        if (options == null) {
            return null;
        }
        int i = 0;
        String[] values = new String[options.size() * 2];
        for (Map.Entry<String, String> entry : options.entrySet()) {
            values[i++] = "-o";
            values[i++] = entry.getKey() + (entry.getValue() == null ? "" : "=" + entry.getValue());
        }
        return values;
    }

    static {
        initLock = new ReentrantLock();
        defaultFilesystemRandom = new Random();
        fusermount = "fusermount";
        umount = "umount";
        currentUid = 0;
        currentGid = 0;
        mountedFs = new ConcurrentHashMap<Path, FuseFilesystem>();
    }

    private static final class MountThread
    extends Thread {
        private Integer result = null;
        private final String[] args;
        private final StructFuseOperations operations;
        private final LibFuse fuse;
        private final Path mountPoint;

        private MountThread(String filesystemName, LibFuse fuse, String[] args, Path mountPoint, StructFuseOperations operations) {
            super(filesystemName + "-fuse");
            this.fuse = fuse;
            this.args = args;
            this.mountPoint = mountPoint;
            this.operations = operations;
        }

        private Integer getResult() {
            return this.result;
        }

        @Override
        public void run() {
            this.result = this.fuse.fuse_main_real(this.args.length, this.args, this.operations, Struct.size((Struct)this.operations), null);
        }
    }
}

