/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.DirectoryFiller;
import co.paralleluniverse.fuse.Fuse;
import co.paralleluniverse.fuse.StructFlock;
import co.paralleluniverse.fuse.StructFuseBufvec;
import co.paralleluniverse.fuse.StructFuseContext;
import co.paralleluniverse.fuse.StructFuseFileInfo;
import co.paralleluniverse.fuse.StructFusePollHandle;
import co.paralleluniverse.fuse.StructStat;
import co.paralleluniverse.fuse.StructStatvfs;
import co.paralleluniverse.fuse.StructTimeBuffer;
import co.paralleluniverse.fuse.XattrFiller;
import co.paralleluniverse.fuse.XattrListFiller;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jnr.ffi.Pointer;
import jnr.ffi.types.gid_t;
import jnr.ffi.types.pid_t;
import jnr.ffi.types.uid_t;

public abstract class FuseFilesystem {
    private static final String defaultFilesystemName = "userfs-";
    private static final Pattern regexNormalizeFilesystemName = Pattern.compile("[^a-zA-Z]");
    private final ReentrantLock mountLock = new ReentrantLock();
    private final AutoUnmountHook unmountHook = new AutoUnmountHook();
    private volatile Path mountPoint = null;
    private Logger logger = null;

    static final void _destroy(FuseFilesystem mountedFilesystem, FuseFilesystem userFilesystem) {
        Path oldMountPoint;
        mountedFilesystem.mountLock.lock();
        userFilesystem.mountLock.lock();
        try {
            if (!mountedFilesystem.isMounted()) {
                throw new IllegalStateException("destroy called on a non-mounted filesystem");
            }
            oldMountPoint = mountedFilesystem.mountPoint;
            Fuse.destroyed(mountedFilesystem);
            userFilesystem.mountPoint = null;
            mountedFilesystem.mountPoint = null;
        }
        finally {
            userFilesystem.mountLock.unlock();
            mountedFilesystem.mountLock.unlock();
        }
        mountedFilesystem.afterUnmount(oldMountPoint);
    }

    protected abstract void afterUnmount(Path var1);

    protected abstract void beforeMount(Path var1);

    public final boolean isMounted() {
        return this.getMountPoint() != null;
    }

    void _destroy() {
        FuseFilesystem._destroy(this, this);
    }

    protected final StructFuseContext getFuseContext() {
        if (!this.isMounted()) {
            throw new IllegalStateException("Cannot get FUSE context if the filesystem is not mounted.");
        }
        return Fuse.getFuseContext();
    }

    @gid_t
    protected long getFuseContextGid() {
        return this.getFuseContext().gid.get();
    }

    @pid_t
    protected long getFuseContextPid() {
        return this.getFuseContext().pid.get();
    }

    @uid_t
    protected long getFuseContextUid() {
        return this.getFuseContext().uid.get();
    }

    final String getFuseName() {
        String name = this.getName();
        if (name == null) {
            return defaultFilesystemName;
        }
        if ((name = regexNormalizeFilesystemName.matcher(name).replaceAll("")).isEmpty()) {
            return defaultFilesystemName;
        }
        return name.toLowerCase();
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    public final Path getMountPoint() {
        return this.mountPoint;
    }

    protected abstract String getName();

    protected abstract String[] getOptions();

    final AutoUnmountHook getUnmountHook() {
        return this.unmountHook;
    }

    protected StructStat defaultStat(StructStat stat) {
        stat.mode(0L).setAllTimesMillis(Fuse.getInitTime()).nlink(1L).uid(Fuse.getUid()).gid(Fuse.getGid());
        return stat;
    }

    public final FuseFilesystem log(boolean logging) {
        return this.log(logging ? Logger.getLogger(this.getClass().getCanonicalName()) : null);
    }

    public final FuseFilesystem log(Logger logger) {
        this.mountLock.lock();
        try {
            if (this.mountPoint != null) {
                throw new IllegalStateException("Cannot turn logging on/orr when filesystem is already mounted.");
            }
            this.logger = logger;
        }
        finally {
            this.mountLock.unlock();
        }
        return this;
    }

    final void mount(Path mountPoint, boolean blocking) throws IOException {
        this.mountLock.lock();
        try {
            if (this.isMounted()) {
                this.mountLock.unlock();
                throw new IllegalStateException(this.getFuseName() + " is already mounted at " + this.mountPoint);
            }
            this.mountPoint = mountPoint;
        }
        finally {
            this.mountLock.unlock();
        }
        this.beforeMount(mountPoint);
    }

    final void unmount() throws IOException {
        if (!this.isMounted()) {
            throw new IllegalStateException("Tried to unmount a filesystem which is not mounted");
        }
    }

    protected abstract int getattr(String var1, StructStat var2);

    protected abstract int readlink(String var1, ByteBuffer var2, long var3);

    protected abstract int mknod(String var1, long var2, long var4);

    protected abstract int mkdir(String var1, long var2);

    protected abstract int unlink(String var1);

    protected abstract int rmdir(String var1);

    protected abstract int symlink(String var1, String var2);

    protected abstract int rename(String var1, String var2);

    protected abstract int link(String var1, String var2);

    protected abstract int chmod(String var1, long var2);

    protected abstract int chown(String var1, long var2, long var4);

    protected abstract int truncate(String var1, long var2);

    protected abstract int open(String var1, StructFuseFileInfo var2);

    protected abstract int read(String var1, ByteBuffer var2, long var3, long var5, StructFuseFileInfo var7);

    protected abstract int write(String var1, ByteBuffer var2, long var3, long var5, StructFuseFileInfo var7);

    protected abstract int statfs(String var1, StructStatvfs var2);

    protected abstract int flush(String var1, StructFuseFileInfo var2);

    protected abstract int release(String var1, StructFuseFileInfo var2);

    protected abstract int fsync(String var1, int var2, StructFuseFileInfo var3);

    protected abstract int setxattr(String var1, String var2, ByteBuffer var3, long var4, int var6, int var7);

    protected abstract int getxattr(String var1, String var2, XattrFiller var3, long var4, long var6);

    protected abstract int listxattr(String var1, XattrListFiller var2);

    protected abstract int removexattr(String var1, String var2);

    protected abstract int opendir(String var1, StructFuseFileInfo var2);

    protected abstract int readdir(String var1, StructFuseFileInfo var2, DirectoryFiller var3);

    protected abstract int releasedir(String var1, StructFuseFileInfo var2);

    protected abstract int fsyncdir(String var1, int var2, StructFuseFileInfo var3);

    protected abstract void init();

    protected abstract void destroy();

    protected abstract int access(String var1, int var2);

    protected abstract int create(String var1, long var2, StructFuseFileInfo var4);

    protected abstract int ftruncate(String var1, long var2, StructFuseFileInfo var4);

    protected abstract int fgetattr(String var1, StructStat var2, StructFuseFileInfo var3);

    protected abstract int lock(String var1, StructFuseFileInfo var2, int var3, StructFlock var4);

    protected abstract int utimens(String var1, StructTimeBuffer var2);

    protected abstract int bmap(String var1, StructFuseFileInfo var2);

    protected abstract int ioctl(String var1, int var2, Pointer var3, StructFuseFileInfo var4, long var5, Pointer var7);

    protected abstract int poll(String var1, StructFuseFileInfo var2, StructFusePollHandle var3, Pointer var4);

    protected abstract int write_buf(String var1, StructFuseBufvec var2, long var3, StructFuseFileInfo var5);

    protected abstract int read_buf(String var1, Pointer var2, long var3, long var5, StructFuseFileInfo var7);

    protected abstract int flock(String var1, StructFuseFileInfo var2, int var3);

    protected abstract int fallocate(String var1, int var2, long var3, long var5, StructFuseFileInfo var7);

    final class AutoUnmountHook
    extends Thread {
        AutoUnmountHook() {
        }

        @Override
        public final void run() {
            try {
                Fuse.unmount(FuseFilesystem.this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

