/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.LibDl;
import co.paralleluniverse.fuse.LibFuse;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Platform;

final class Platform {
    private static final String[] osxFuseLibraries = new String[]{"fuse4x", "osxfuse", "macfuse", "fuse"};
    private static PlatformEnum platform = null;
    private static LibFuse libFuse = null;
    private static final Lock initLock = new ReentrantLock();

    Platform() {
    }

    static final LibFuse fuse() {
        if (libFuse == null) {
            Platform.init();
        }
        return libFuse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (libFuse != null) {
            return;
        }
        initLock.lock();
        try {
            jnr.ffi.Platform p = jnr.ffi.Platform.getNativePlatform();
            if (libFuse != null) return;
            switch (p.getOS()) {
                case FREEBSD: {
                    platform = PlatformEnum.FREEBSD;
                    libFuse = (LibFuse)LibraryLoader.create(LibFuse.class).failImmediately().load("fuse");
                    return;
                }
                case DARWIN: {
                    LibDl dl = (LibDl)LibraryLoader.create(LibDl.class).failImmediately().load("iconv");
                    dl.dlopen("iconv", 257);
                    libFuse = null;
                    for (String library : osxFuseLibraries) {
                        try {
                            platform = PlatformEnum.MAC;
                            libFuse = (LibFuse)LibraryLoader.create(LibFuse.class).failImmediately().load(library);
                            break;
                        }
                        catch (Throwable throwable) {
                            try {
                                LibFuse.LibFuseProbe probe = (LibFuse.LibFuseProbe)LibraryLoader.create(LibFuse.LibMacFuseProbe.class).failImmediately().load(library);
                                ((LibFuse.LibMacFuseProbe)probe).macfuse_version();
                                platform = PlatformEnum.MAC_MACFUSE;
                                libFuse = (LibFuse)LibraryLoader.create(LibFuse.class).failImmediately().load("fuse");
                                break;
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                    }
                    if (libFuse != null) return;
                    libFuse = (LibFuse)LibraryLoader.create(LibFuse.class).failImmediately().load("fuse");
                    return;
                }
                default: {
                    platform = p.getCPU() == Platform.CPU.X86_64 ? PlatformEnum.LINUX_X86_64 : (p.getCPU() == Platform.CPU.I386 ? PlatformEnum.LINUX_I686 : (p.getCPU() == Platform.CPU.ARM ? PlatformEnum.LINUX_ARM : PlatformEnum.LINUX_PPC));
                    libFuse = (LibFuse)LibraryLoader.create(LibFuse.class).failImmediately().load("fuse");
                    return;
                }
            }
        }
        finally {
            initLock.unlock();
        }
    }

    public static final PlatformEnum platform() {
        if (platform == null) {
            Platform.init();
        }
        return platform;
    }

    public static enum PlatformEnum {
        LINUX_X86_64,
        LINUX_I686,
        LINUX_PPC,
        MAC,
        MAC_MACFUSE,
        FREEBSD,
        LINUX_ARM;

    }
}

