/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

final class ProcessGobbler {
    private final Process process;
    private final Gobbler stdout;
    private final Gobbler stderr;
    private Integer returnCode = null;

    ProcessGobbler(String ... args) throws IOException {
        this.process = new ProcessBuilder(args).start();
        this.stdout = new Gobbler(this.process.getInputStream());
        this.stderr = new Gobbler(this.process.getErrorStream());
    }

    int getReturnCode() {
        try {
            this.returnCode = this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.returnCode;
    }

    String getStderr() {
        try {
            this.stderr.join();
        }
        catch (InterruptedException e) {
            return null;
        }
        return this.stderr.getContents();
    }

    String getStdout() {
        try {
            this.stdout.join();
        }
        catch (InterruptedException e) {
            return null;
        }
        return this.stdout.getContents();
    }

    private static final class Gobbler
    extends Thread {
        private final InputStream stream;
        private String contents = null;
        private boolean failed = false;

        Gobbler(InputStream stream) {
            this.stream = stream;
            this.start();
        }

        private String getContents() {
            if (this.failed) {
                return null;
            }
            return this.contents;
        }

        @Override
        public final void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
            StringBuilder contents = new StringBuilder();
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    contents.append(line);
                }
            }
            catch (IOException e) {
                this.failed = true;
                return;
            }
            this.contents = contents.toString();
        }
    }
}

