/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.JNRUtil;
import co.paralleluniverse.fuse.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;

public class StructFlock {
    public static final int CMD_GETLK = 5;
    public static final int CMD_SETLK = 6;
    public static final int CMD_SETLKW = 7;
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_UN = 8;
    public static final int F_RDLCK = 0;
    public static final int F_WRLCK = 1;
    public static final int F_UNLCK = 2;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    public static final int SEEK_END = 2;
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());
    private final Pointer p;
    private final String path;

    StructFlock(Pointer p, String path) {
        this.p = p;
        this.path = path;
    }

    public final int type() {
        return (int)StructFlock.layout.l_type.get(this.p);
    }

    public final StructFlock type(int l_type) {
        StructFlock.layout.l_type.set(this.p, (long)l_type);
        return this;
    }

    public final long len() {
        return StructFlock.layout.l_len.get(this.p);
    }

    public final StructFlock len(long l_len) {
        StructFlock.layout.l_len.set(this.p, l_len);
        return this;
    }

    public final long pid() {
        return StructFlock.layout.l_pid.get(this.p);
    }

    public final StructFlock pid(long l_pid) {
        StructFlock.layout.l_pid.set(this.p, l_pid);
        return this;
    }

    public final long start() {
        return StructFlock.layout.l_start.get(this.p);
    }

    public final StructFlock start(long l_start) {
        StructFlock.layout.l_start.set(this.p, l_start);
        return this;
    }

    public final long sysid() {
        return StructFlock.layout.l_sysid != null ? StructFlock.layout.l_sysid.get(this.p) : -1L;
    }

    public final StructFlock sysid(long l_sysid) {
        StructFlock.layout.l_sysid.set(this.p, l_sysid);
        return this;
    }

    public final long whence() {
        return StructFlock.layout.l_whence.get(this.p);
    }

    public final StructFlock whence(long l_whence) {
        StructFlock.layout.l_whence.set(this.p, l_whence);
        return this;
    }

    public final String toString() {
        if (this.path != null) {
            return this.path + "\n" + JNRUtil.toString(layout, this.p);
        }
        return JNRUtil.toString(layout, this.p);
    }

    private static final class Layout
    extends StructLayout {
        public final StructLayout.int16_t l_type;
        public final StructLayout.int16_t l_whence;
        public final StructLayout.off_t l_start;
        public final StructLayout.off_t l_len;
        public final StructLayout.pid_t l_pid;
        public final StructLayout.int32_t l_sysid;

        private Layout(Runtime runtime) {
            super(runtime);
            switch (Platform.platform()) {
                case FREEBSD: {
                    this.l_start = new StructLayout.off_t((StructLayout)this);
                    this.l_len = new StructLayout.off_t((StructLayout)this);
                    this.l_pid = new StructLayout.pid_t((StructLayout)this);
                    this.l_type = new StructLayout.int16_t((StructLayout)this);
                    this.l_whence = new StructLayout.int16_t((StructLayout)this);
                    this.l_sysid = new StructLayout.int32_t((StructLayout)this);
                    break;
                }
                default: {
                    this.l_type = new StructLayout.int16_t((StructLayout)this);
                    this.l_whence = new StructLayout.int16_t((StructLayout)this);
                    this.l_start = new StructLayout.off_t((StructLayout)this);
                    this.l_len = new StructLayout.off_t((StructLayout)this);
                    this.l_pid = new StructLayout.pid_t((StructLayout)this);
                    this.l_sysid = null;
                }
            }
        }
    }
}

