/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.JNRUtil;
import co.paralleluniverse.fuse.Platform;
import co.paralleluniverse.fuse.StructTimespec;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;

public class StructStat {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());
    private final Pointer p;
    final String path;

    public StructStat(Pointer p, String path) {
        this.p = p;
        this.path = path;
    }

    private void setTime(StructTimespec.Layout layout, long sec, long nsec) {
        StructTimespec.set(layout, this.p, sec, nsec);
    }

    public StructStat atime(long sec) {
        return this.atime(sec, 0L);
    }

    public StructStat atime(long sec, long nsec) {
        this.setTime(StructStat.layout.st_atime, sec, nsec);
        return this;
    }

    public StructStat blksize(long blksize) {
        StructStat.layout.st_blksize.set(this.p, blksize);
        return this;
    }

    public StructStat blocks(long blocks) {
        StructStat.layout.st_blocks.set(this.p, blocks);
        return this;
    }

    public StructStat ctime(long sec) {
        return this.ctime(sec, 0L);
    }

    public StructStat ctime(long sec, long nsec) {
        this.setTime(StructStat.layout.st_ctime, sec, nsec);
        return this;
    }

    public StructStat dev(long dev) {
        StructStat.layout.st_dev.set(this.p, dev);
        return this;
    }

    public StructStat gen(long gen) {
        if (StructStat.layout.st_gen != null) {
            StructStat.layout.st_gen.set(this.p, gen);
        }
        return this;
    }

    public StructStat gid(long gid) {
        StructStat.layout.st_gid.set(this.p, gid);
        return this;
    }

    public StructStat ino(long ino) {
        StructStat.layout.st_ino.set(this.p, ino);
        return this;
    }

    public StructStat lspare(long lspare) {
        if (StructStat.layout.st_lspare != null) {
            StructStat.layout.st_lspare.set(this.p, lspare);
        }
        return this;
    }

    public long mode() {
        return StructStat.layout.st_mode.get(this.p);
    }

    public StructStat mode(long bits) {
        StructStat.layout.st_mode.set(this.p, bits);
        return this;
    }

    public StructStat mtime(long sec) {
        return this.mtime(sec, 0L);
    }

    public StructStat mtime(long sec, long nsec) {
        this.setTime(StructStat.layout.st_mtime, sec, nsec);
        return this;
    }

    public StructStat nlink(long nlink) {
        StructStat.layout.st_nlink.set(this.p, nlink);
        return this;
    }

    public StructStat qspare(long qspare) {
        if (StructStat.layout.st_qspare != null) {
            StructStat.layout.st_qspare.set(this.p, qspare);
        }
        return this;
    }

    public StructStat rdev(long rdev) {
        StructStat.layout.st_rdev.set(this.p, rdev);
        return this;
    }

    public StructStat setAllTimes(long sec, long nsec) {
        return this.setTimes(sec, nsec, sec, nsec, sec, nsec);
    }

    public StructStat setAllTimesMillis(long millis) {
        long sec = millis / 1000L;
        long nsec = millis % 1000L * 1000000L;
        return this.setAllTimes(sec, nsec);
    }

    public StructStat setAllTimesSec(long sec) {
        return this.setAllTimesSec(sec, sec, sec);
    }

    public StructStat setAllTimesSec(long atime, long mtime, long ctime) {
        return this.setAllTimesSec(atime, mtime, ctime, ctime);
    }

    public StructStat setAllTimesSec(long atime, long mtime, long ctime, long birthtime) {
        return this.setTimes(atime, 0L, mtime, 0L, ctime, 0L);
    }

    public StructStat setTimes(long atime_sec, long atime_nsec, long mtime_sec, long mtime_nsec, long ctime_sec, long ctime_nsec) {
        return this.setTimes(atime_sec, atime_nsec, mtime_sec, mtime_nsec, ctime_sec, ctime_nsec, ctime_sec, ctime_nsec);
    }

    public StructStat setTimes(long atime_sec, long atime_nsec, long mtime_sec, long mtime_nsec, long ctime_sec, long ctime_nsec, long birthtime_sec, long birthtime_nsec) {
        this.setTime(StructStat.layout.st_atime, atime_sec, atime_nsec);
        this.setTime(StructStat.layout.st_mtime, mtime_sec, mtime_nsec);
        this.setTime(StructStat.layout.st_ctime, ctime_sec, ctime_nsec);
        if (StructStat.layout.st_birthtime != null) {
            this.setTime(StructStat.layout.st_birthtime, birthtime_sec, birthtime_nsec);
        }
        return this;
    }

    public StructStat size(long size) {
        StructStat.layout.st_size.set(this.p, size);
        return this;
    }

    public StructStat uid(long uid) {
        StructStat.layout.st_uid.set(this.p, uid);
        return this;
    }

    public String toString() {
        if (this.path != null) {
            return this.path + "\n" + JNRUtil.toString(layout, this.p);
        }
        return JNRUtil.toString(layout, this.p);
    }

    private static final class Layout
    extends StructLayout {
        public final StructLayout.dev_t st_dev;
        public final StructLayout.ino_t st_ino;
        public final StructLayout.mode_t st_mode;
        public final StructLayout.nlink_t st_nlink;
        public final StructLayout.uid_t st_uid;
        public final StructLayout.gid_t st_gid;
        public final StructLayout.dev_t st_rdev;
        public final StructTimespec.Layout st_atime;
        public final StructTimespec.Layout st_mtime;
        public final StructTimespec.Layout st_ctime;
        public final StructTimespec.Layout st_birthtime;
        public final StructLayout.off_t st_size;
        public final StructLayout.blkcnt_t st_blocks;
        public final StructLayout.blksize_t st_blksize;
        public final StructLayout.int32_t st_gen;
        public final StructLayout.int32_t st_lspare;
        public final StructLayout.int64_t st_qspare;

        private Layout(Runtime runtime) {
            super(runtime);
            switch (Platform.platform()) {
                case LINUX_X86_64: {
                    this.st_dev = new StructLayout.dev_t((StructLayout)this);
                    this.st_ino = new StructLayout.ino_t((StructLayout)this);
                    this.st_nlink = new StructLayout.nlink_t((StructLayout)this);
                    this.st_mode = new StructLayout.mode_t((StructLayout)this);
                    this.st_uid = new StructLayout.uid_t((StructLayout)this);
                    this.st_gid = new StructLayout.gid_t((StructLayout)this);
                    StructLayout.int32_t __pad0 = new StructLayout.int32_t((StructLayout)this);
                    this.st_rdev = new StructLayout.dev_t((StructLayout)this);
                    this.st_size = new StructLayout.off_t((StructLayout)this);
                    this.st_blksize = new StructLayout.blksize_t((StructLayout)this);
                    this.st_blocks = new StructLayout.blkcnt_t((StructLayout)this);
                    this.st_atime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_mtime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_ctime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_birthtime = null;
                    this.st_gen = null;
                    this.st_lspare = null;
                    this.st_qspare = null;
                    break;
                }
                case LINUX_ARM: 
                case LINUX_I686: {
                    this.st_dev = new StructLayout.dev_t((StructLayout)this);
                    StructLayout.int16_t __pad1 = new StructLayout.int16_t((StructLayout)this);
                    StructLayout.u_int32_t __st_ino = new StructLayout.u_int32_t((StructLayout)this);
                    this.st_mode = new StructLayout.mode_t((StructLayout)this);
                    this.st_nlink = new StructLayout.nlink_t((StructLayout)this);
                    this.st_uid = new StructLayout.uid_t((StructLayout)this);
                    this.st_gid = new StructLayout.gid_t((StructLayout)this);
                    this.st_rdev = new StructLayout.dev_t((StructLayout)this);
                    StructLayout.int16_t __pad2 = new StructLayout.int16_t((StructLayout)this);
                    this.st_size = new StructLayout.off_t((StructLayout)this);
                    this.st_blksize = new StructLayout.blksize_t((StructLayout)this);
                    this.st_blocks = new StructLayout.blkcnt_t((StructLayout)this);
                    this.st_atime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_mtime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_ctime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_ino = new StructLayout.ino_t((StructLayout)this);
                    this.st_birthtime = null;
                    this.st_gen = null;
                    this.st_lspare = null;
                    this.st_qspare = null;
                    break;
                }
                case LINUX_PPC: {
                    this.st_dev = new StructLayout.dev_t((StructLayout)this);
                    this.st_ino = new StructLayout.ino_t((StructLayout)this);
                    this.st_mode = new StructLayout.mode_t((StructLayout)this);
                    this.st_nlink = new StructLayout.nlink_t((StructLayout)this);
                    this.st_uid = new StructLayout.uid_t((StructLayout)this);
                    this.st_gid = new StructLayout.gid_t((StructLayout)this);
                    this.st_rdev = new StructLayout.dev_t((StructLayout)this);
                    StructLayout.int16_t __pad0 = new StructLayout.int16_t((StructLayout)this);
                    this.st_size = new StructLayout.off_t((StructLayout)this);
                    this.st_blksize = new StructLayout.blksize_t((StructLayout)this);
                    this.st_blocks = new StructLayout.blkcnt_t((StructLayout)this);
                    this.st_atime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_mtime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_ctime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_birthtime = null;
                    this.st_gen = null;
                    this.st_lspare = null;
                    this.st_qspare = null;
                    break;
                }
                case MAC: {
                    this.st_dev = new StructLayout.dev_t((StructLayout)this);
                    this.st_mode = new StructLayout.mode_t((StructLayout)this);
                    this.st_nlink = new StructLayout.nlink_t((StructLayout)this);
                    this.st_ino = new StructLayout.ino_t((StructLayout)this);
                    this.st_uid = new StructLayout.uid_t((StructLayout)this);
                    this.st_gid = new StructLayout.gid_t((StructLayout)this);
                    this.st_rdev = new StructLayout.dev_t((StructLayout)this);
                    this.st_atime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_mtime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_ctime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_birthtime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_size = new StructLayout.off_t((StructLayout)this);
                    this.st_blocks = new StructLayout.blkcnt_t((StructLayout)this);
                    this.st_blksize = new StructLayout.blksize_t((StructLayout)this);
                    this.st_gen = new StructLayout.int32_t((StructLayout)this);
                    this.st_lspare = new StructLayout.int32_t((StructLayout)this);
                    this.st_qspare = new StructLayout.int64_t((StructLayout)this);
                    break;
                }
                case FREEBSD: 
                case MAC_MACFUSE: {
                    this.st_dev = new StructLayout.dev_t((StructLayout)this);
                    this.st_ino = new StructLayout.ino_t((StructLayout)this);
                    this.st_mode = new StructLayout.mode_t((StructLayout)this);
                    this.st_nlink = new StructLayout.nlink_t((StructLayout)this);
                    this.st_uid = new StructLayout.uid_t((StructLayout)this);
                    this.st_gid = new StructLayout.gid_t((StructLayout)this);
                    this.st_rdev = new StructLayout.dev_t((StructLayout)this);
                    this.st_atime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_mtime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_ctime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
                    this.st_size = new StructLayout.off_t((StructLayout)this);
                    this.st_blocks = new StructLayout.blkcnt_t((StructLayout)this);
                    this.st_blksize = new StructLayout.blksize_t((StructLayout)this);
                    this.st_birthtime = null;
                    this.st_gen = null;
                    this.st_lspare = null;
                    this.st_qspare = null;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }
}

