/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.JNRUtil;
import co.paralleluniverse.fuse.Platform;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;

public class StructStatvfs {
    public static final int ST_RDONLY = 1;
    public static final int ST_NOSUID = 2;
    public static final int ST_NODEV = 4;
    public static final int ST_NOEXEC = 8;
    public static final int ST_SYNCHRONOUS = 16;
    public static final int ST_MANDLOCK = 64;
    public static final int ST_WRITE = 128;
    public static final int ST_APPEND = 256;
    public static final int ST_IMMUTABLE = 512;
    public static final int ST_NOATIME = 1024;
    public static final int ST_NODIRATIME = 2048;
    public static final int ST_RELATIME = 4096;
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());
    private final Pointer p;
    private final String path;

    public StructStatvfs(Pointer p, String path) {
        this.p = p;
        this.path = path;
    }

    public final long bavail() {
        return StructStatvfs.layout.f_bavail.get(this.p);
    }

    public final StructStatvfs bavail(long f_bavail) {
        StructStatvfs.layout.f_bavail.set(this.p, f_bavail);
        return this;
    }

    public final long bfree() {
        return StructStatvfs.layout.f_bfree.get(this.p);
    }

    public final StructStatvfs bfree(long f_bfree) {
        StructStatvfs.layout.f_bfree.set(this.p, f_bfree);
        return this;
    }

    public final long blocks() {
        return StructStatvfs.layout.f_blocks.get(this.p);
    }

    public final StructStatvfs blocks(long f_blocks) {
        StructStatvfs.layout.f_blocks.set(this.p, f_blocks);
        return this;
    }

    public final long bsize() {
        return StructStatvfs.layout.f_bsize.get(this.p);
    }

    public final StructStatvfs bsize(long f_bsize) {
        StructStatvfs.layout.f_bsize.set(this.p, f_bsize);
        return this;
    }

    public final long favail() {
        return StructStatvfs.layout.f_favail.get(this.p);
    }

    public final StructStatvfs favail(long f_favail) {
        StructStatvfs.layout.f_favail.set(this.p, f_favail);
        return this;
    }

    public final long ffree() {
        return StructStatvfs.layout.f_ffree.get(this.p);
    }

    public final StructStatvfs ffree(long f_ffree) {
        StructStatvfs.layout.f_ffree.set(this.p, f_ffree);
        return this;
    }

    public final long files() {
        return StructStatvfs.layout.f_files.get(this.p);
    }

    public final StructStatvfs files(long f_files) {
        StructStatvfs.layout.f_files.set(this.p, f_files);
        return this;
    }

    public final long frsize() {
        return StructStatvfs.layout.f_frsize.get(this.p);
    }

    public final StructStatvfs frsize(long f_frsize) {
        StructStatvfs.layout.f_frsize.set(this.p, f_frsize);
        return this;
    }

    public final long flags() {
        return StructStatvfs.layout.f_flag.get(this.p);
    }

    public final StructStatvfs flags(long f_flags) {
        StructStatvfs.layout.f_flag.set(this.p, f_flags);
        return this;
    }

    public final StructStatvfs set(long blockSize, long fragmentSize, long freeBlocks, long availBlocks, long totalBlocks, long freeFiles, long availFiles, long totalFiles) {
        return this.setSizes(blockSize, fragmentSize).setBlockInfo(freeBlocks, availBlocks, totalBlocks).setFileInfo(freeFiles, availFiles, totalFiles);
    }

    public final StructStatvfs setBlockInfo(long freeBlocks, long availBlocks, long totalBlocks) {
        return this.bfree(freeBlocks).bavail(availBlocks).blocks(totalBlocks);
    }

    public final StructStatvfs setFileInfo(long freeFiles, long availFiles, long totalFiles) {
        return this.ffree(freeFiles).favail(availFiles).files(totalFiles);
    }

    public final StructStatvfs setSizes(long blockSize, long fragmentSize) {
        return this.bsize(blockSize).frsize(fragmentSize);
    }

    public final String toString() {
        if (this.path != null) {
            return this.path + "\n" + JNRUtil.toString(layout, this.p);
        }
        return JNRUtil.toString(layout, this.p);
    }

    private static final class Layout
    extends StructLayout {
        public final StructLayout.SignedLong f_bsize;
        public final StructLayout.SignedLong f_frsize;
        public final StructLayout.blkcnt_t f_blocks;
        public final StructLayout.blkcnt_t f_bfree;
        public final StructLayout.blkcnt_t f_bavail;
        public final StructLayout.fsfilcnt_t f_files;
        public final StructLayout.fsfilcnt_t f_ffree;
        public final StructLayout.fsfilcnt_t f_favail;
        public final StructLayout.Signed32 f_unused;
        public final StructLayout.UnsignedLong f_flag;
        public final StructLayout.UnsignedLong f_namemax;
        public final StructLayout.Signed32[] __f_spare;

        private Layout(Runtime runtime) {
            super(runtime);
            switch (Platform.platform()) {
                case FREEBSD: {
                    this.f_bavail = new StructLayout.blkcnt_t((StructLayout)this);
                    this.f_bfree = new StructLayout.blkcnt_t((StructLayout)this);
                    this.f_blocks = new StructLayout.blkcnt_t((StructLayout)this);
                    this.f_ffree = new StructLayout.fsfilcnt_t((StructLayout)this);
                    this.f_favail = new StructLayout.fsfilcnt_t((StructLayout)this);
                    this.f_files = new StructLayout.fsfilcnt_t((StructLayout)this);
                    this.f_bsize = new StructLayout.SignedLong((StructLayout)this);
                    StructLayout.SignedLong __pad0 = new StructLayout.SignedLong((StructLayout)this);
                    this.f_frsize = new StructLayout.SignedLong((StructLayout)this);
                    break;
                }
                default: {
                    this.f_bsize = new StructLayout.SignedLong((StructLayout)this);
                    this.f_frsize = new StructLayout.SignedLong((StructLayout)this);
                    this.f_blocks = new StructLayout.blkcnt_t((StructLayout)this);
                    this.f_bfree = new StructLayout.blkcnt_t((StructLayout)this);
                    this.f_bavail = new StructLayout.blkcnt_t((StructLayout)this);
                    this.f_files = new StructLayout.fsfilcnt_t((StructLayout)this);
                    this.f_ffree = new StructLayout.fsfilcnt_t((StructLayout)this);
                    this.f_favail = new StructLayout.fsfilcnt_t((StructLayout)this);
                }
            }
            boolean is32bit = jnr.ffi.Platform.getNativePlatform().getCPU() == Platform.CPU.I386 || jnr.ffi.Platform.getNativePlatform().getCPU() == Platform.CPU.ARM;
            this.f_unused = is32bit ? new StructLayout.Signed32((StructLayout)this) : null;
            this.f_flag = new StructLayout.UnsignedLong((StructLayout)this);
            this.f_namemax = new StructLayout.UnsignedLong((StructLayout)this);
            this.__f_spare = (StructLayout.Signed32[])this.array((StructLayout.Field[])new StructLayout.Signed32[6]);
        }
    }
}

