/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import co.paralleluniverse.fuse.StructTimespec;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;

public final class StructTimeBuffer {
    static final Layout layout = new Layout(Runtime.getSystemRuntime());
    private final Pointer p;

    StructTimeBuffer(Pointer p) {
        this.p = p;
    }

    public long ac_nsec() {
        return StructTimeBuffer.layout.actime.tv_nsec.get(this.p);
    }

    public long ac_sec() {
        return StructTimeBuffer.layout.actime.tv_sec.get(this.p);
    }

    public StructTimeBuffer ac_set(double time) {
        StructTimespec.set(StructTimeBuffer.layout.actime, this.p, time);
        return this;
    }

    public StructTimeBuffer ac_set(long sec, long nsec) {
        StructTimespec.set(StructTimeBuffer.layout.actime, this.p, sec, nsec);
        return this;
    }

    public StructTimeBuffer ac_setMillis(long millis) {
        StructTimespec.setMillis(StructTimeBuffer.layout.actime, this.p, millis);
        return this;
    }

    public StructTimeBuffer ac_setSeconds(long seconds) {
        StructTimespec.setSeconds(StructTimeBuffer.layout.actime, this.p, seconds);
        return this;
    }

    public long mod_nsec() {
        return StructTimeBuffer.layout.modtime.tv_nsec.get(this.p);
    }

    public long mod_sec() {
        return StructTimeBuffer.layout.modtime.tv_sec.get(this.p);
    }

    public final StructTimeBuffer mod_set(double time) {
        StructTimespec.set(StructTimeBuffer.layout.modtime, this.p, time);
        return this;
    }

    public StructTimeBuffer mod_set(long sec, long nsec) {
        StructTimespec.set(StructTimeBuffer.layout.modtime, this.p, sec, nsec);
        return this;
    }

    public StructTimeBuffer mod_setMillis(long millis) {
        StructTimespec.setMillis(StructTimeBuffer.layout.modtime, this.p, millis);
        return this;
    }

    public StructTimeBuffer mod_setSeconds(long seconds) {
        StructTimespec.setSeconds(StructTimeBuffer.layout.modtime, this.p, seconds);
        return this;
    }

    public StructTimeBuffer both_set(double time) {
        this.ac_set(time);
        this.mod_set(time);
        return this;
    }

    public StructTimeBuffer both_set(long sec, long nsec) {
        this.ac_set(sec, nsec);
        this.mod_set(sec, nsec);
        return this;
    }

    public StructTimeBuffer both_setMillis(long millis) {
        this.ac_setMillis(millis);
        this.mod_setMillis(millis);
        return this;
    }

    public StructTimeBuffer both_setSeconds(long seconds) {
        this.ac_setSeconds(seconds);
        this.mod_setSeconds(seconds);
        return this;
    }

    public String toString() {
        return layout.toString();
    }

    static final class Layout
    extends StructLayout {
        public final StructTimespec.Layout actime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));
        public final StructTimespec.Layout modtime = (StructTimespec.Layout)this.inner(new StructTimespec.Layout(this.getRuntime()));

        Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

