/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.StructLayout;

final class StructTimespec {
    static final Layout layout = new Layout(Runtime.getSystemRuntime());
    private final Pointer p;

    public StructTimespec(Pointer p) {
        this.p = p;
    }

    public long nsec() {
        return StructTimespec.layout.tv_nsec.longValue(this.p);
    }

    public long sec() {
        return StructTimespec.layout.tv_sec.longValue(this.p);
    }

    public void set(double time) {
        StructTimespec.set(layout, this.p, time);
    }

    public void set(long sec, long nsec) {
        StructTimespec.set(layout, this.p, sec, nsec);
    }

    public void setMillis(long millis) {
        this.set(millis / 1000L, millis % 1000L * 1000000L);
    }

    public void setSeconds(long seconds) {
        this.set(seconds);
    }

    static void set(Layout layout, Pointer p, double time) {
        StructTimespec.set(layout, p, (long)time, (long)(time * 1.0E9));
    }

    static void set(Layout layout, Pointer p, long sec, long nsec) {
        layout.tv_sec.set(p, sec);
        layout.tv_nsec.set(p, nsec);
    }

    static void setMillis(Layout layout, Pointer p, long millis) {
        StructTimespec.set(layout, p, millis / 1000L, millis % 1000L * 1000000L);
    }

    static void setSeconds(Layout layout, Pointer p, long seconds) {
        StructTimespec.set(layout, p, seconds);
    }

    static final class Layout
    extends StructLayout {
        public final StructLayout.SignedLong tv_sec = new StructLayout.SignedLong((StructLayout)this);
        public final StructLayout.SignedLong tv_nsec = new StructLayout.SignedLong((StructLayout)this);

        Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

