/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import java.nio.ByteBuffer;
import java.util.Arrays;

public final class XattrFiller {
    private final ByteBuffer buffer;
    private final long maxSize;
    private final int position;
    private byte[] value = null;
    private boolean isSet = false;

    XattrFiller(ByteBuffer buffer, long size, int position) {
        this.buffer = buffer;
        this.maxSize = size;
        this.position = position;
    }

    long getSize() {
        return this.value == null ? 0L : (long)this.value.length;
    }

    public final void set(byte[] value) {
        if (this.buffer != null && value != null) {
            if (this.isSet) {
                throw new IllegalStateException("Cannot set the xattr twice.");
            }
            this.isSet = true;
            if ((long)value.length > (long)this.position + this.maxSize) {
                value = Arrays.copyOf(value, this.position + (int)this.maxSize);
            }
            this.buffer.put(value, this.position, value.length);
        }
        this.value = value;
    }
}

