/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fuse;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class XattrListFiller {
    private final ByteBuffer buffer;
    private final long maxSize;
    private long currentSize = 0L;
    private final Set<String> addedXattrs = new HashSet<String>();

    XattrListFiller(ByteBuffer buffer, long size) {
        this.buffer = buffer;
        this.maxSize = size;
    }

    public final boolean add(Iterable<String> xattrs) {
        for (String xattr : xattrs) {
            byte[] bytes;
            if (this.addedXattrs.contains(xattr)) continue;
            if (this.currentSize >= this.maxSize && this.buffer != null) {
                return false;
            }
            boolean hasNullByte = (bytes = xattr.getBytes())[bytes.length - 1] == 0;
            int size = bytes.length + (hasNullByte ? 0 : 1);
            if (this.currentSize + (long)size > this.maxSize && this.buffer != null) {
                return false;
            }
            this.addedXattrs.add(xattr);
            if (this.buffer != null) {
                this.buffer.put(bytes);
                if (!hasNullByte) {
                    this.buffer.put((byte)0);
                }
            }
            this.currentSize += (long)size;
        }
        return true;
    }

    public final boolean add(String ... xattrs) {
        return this.add(Arrays.asList(xattrs));
    }

    public final long requiredSize() {
        return this.currentSize;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        int count = 0;
        for (String xattr : this.addedXattrs) {
            output.append(xattr);
            if (count < this.addedXattrs.size() - 1) {
                output.append(", ");
            }
            ++count;
        }
        return output.toString();
    }
}

