/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.javafs;

import co.paralleluniverse.fuse.AccessConstants;
import co.paralleluniverse.fuse.DirectoryFiller;
import co.paralleluniverse.fuse.FuseFilesystem;
import co.paralleluniverse.fuse.StructFlock;
import co.paralleluniverse.fuse.StructFuseBufvec;
import co.paralleluniverse.fuse.StructFuseFileInfo;
import co.paralleluniverse.fuse.StructFusePollHandle;
import co.paralleluniverse.fuse.StructStat;
import co.paralleluniverse.fuse.StructStatvfs;
import co.paralleluniverse.fuse.StructTimeBuffer;
import co.paralleluniverse.fuse.XattrFiller;
import co.paralleluniverse.fuse.XattrListFiller;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import jnr.constants.platform.Errno;
import jnr.ffi.Pointer;

class FuseFileSystemProvider
extends FuseFilesystem {
    private final FileSystemProvider fsp;
    private final FileSystem fs;
    private final ConcurrentMap<Long, Object> openFiles = new ConcurrentHashMap<Long, Object>();
    private final AtomicLong fileHandle = new AtomicLong(0L);
    private final boolean debug;
    private static final long BLOCK_SIZE = 4096L;

    public FuseFileSystemProvider(FileSystemProvider fsp, URI uri, boolean debug) {
        this.fsp = fsp;
        this.fs = fsp.getFileSystem(uri);
        this.debug = debug;
    }

    public FuseFileSystemProvider(FileSystem fs, boolean debug) {
        this.fsp = fs.provider();
        this.fs = fs;
        this.debug = debug;
    }

    private Path path(String p) {
        return this.fs.getPath(p, new String[0]);
    }

    @Override
    protected void afterUnmount(Path mountPoint) {
    }

    @Override
    protected void beforeMount(Path mountPoint) {
    }

    @Override
    protected String getName() {
        return this.fs.toString();
    }

    @Override
    protected String[] getOptions() {
        return null;
    }

    @Override
    protected int getattr(String path, StructStat stat) {
        try {
            PosixFileAttributes pas;
            Path p = this.path(path);
            BasicFileAttributes attributes = this.fsp.readAttributes(p, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            stat.atime(FuseFileSystemProvider.sec(attributes.lastAccessTime()), FuseFileSystemProvider.nsec(attributes.lastAccessTime()));
            stat.mtime(FuseFileSystemProvider.sec(attributes.lastModifiedTime()), FuseFileSystemProvider.nsec(attributes.lastModifiedTime()));
            stat.ctime(FuseFileSystemProvider.sec(attributes.creationTime()), FuseFileSystemProvider.nsec(attributes.creationTime()));
            stat.size(attributes.size());
            long mode = 0L;
            if (attributes.isRegularFile()) {
                mode = 32768L;
            } else if (attributes.isDirectory()) {
                mode = 16384L;
            } else if (attributes.isSymbolicLink()) {
                mode = 40960L;
            }
            PosixFileAttributes posixFileAttributes = pas = attributes instanceof PosixFileAttributes ? (PosixFileAttributes)attributes : null;
            if (pas == null) {
                try {
                    pas = this.fsp.readAttributes(p, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if (pas != null) {
                mode |= FuseFileSystemProvider.permissionsToMode(pas.permissions());
            }
            stat.mode(mode);
            try {
                Map<String, Object> uattrs = this.fsp.readAttributes(p, "unix:*", LinkOption.NOFOLLOW_LINKS);
                int uid = (Integer)uattrs.get("uid");
                stat.uid(uid);
                int gid = (Integer)uattrs.get("gid");
                stat.gid(gid);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int readlink(String path, ByteBuffer buffer, long size) {
        try {
            FuseFileSystemProvider.fillBufferWithString(this.fsp.readSymbolicLink(this.path(path)).toString(), buffer, size);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int mknod(String path, long mode, long dev) {
        return this.create(path, mode, null);
    }

    @Override
    protected int mkdir(String path, long mode) {
        try {
            this.fsp.createDirectory(this.path(path), PosixFilePermissions.asFileAttribute(FuseFileSystemProvider.modeToPermissions(mode)));
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int unlink(String path) {
        try {
            Path p = this.path(path);
            if (Files.isDirectory(p, new LinkOption[0])) {
                throw new IOException(p + " is a directory");
            }
            this.fsp.delete(this.path(path));
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int rmdir(String path) {
        try {
            Path p = this.path(path);
            if (!Files.isDirectory(p, new LinkOption[0])) {
                throw new IOException(p + " is not a directory");
            }
            this.fsp.delete(p);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int symlink(String path, String target) {
        try {
            this.fsp.createSymbolicLink(this.path(path), this.path(target), new FileAttribute[0]);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int rename(String path, String newName) {
        try {
            this.fsp.move(this.path(path), this.path(newName), new CopyOption[0]);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int link(String path, String target) {
        try {
            this.fsp.createLink(this.path(target), this.path(path));
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int chmod(String path, long mode) {
        try {
            PosixFileAttributeView attrs = this.fsp.getFileAttributeView(this.path(path), PosixFileAttributeView.class, new LinkOption[0]);
            attrs.setPermissions(FuseFileSystemProvider.modeToPermissions(mode));
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int chown(String path, long uid, long gid) {
        try {
            PosixFileAttributeView attrs = this.fsp.getFileAttributeView(this.path(path), PosixFileAttributeView.class, new LinkOption[0]);
            attrs.setOwner(this.fs.getUserPrincipalLookupService().lookupPrincipalByName(Long.toString(uid)));
            attrs.setGroup(this.fs.getUserPrincipalLookupService().lookupPrincipalByGroupName(Long.toString(gid)));
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int truncate(String path, long offset) {
        try {
            SeekableByteChannel ch = this.fsp.newByteChannel(this.path(path), EnumSet.of(StandardOpenOption.WRITE), new FileAttribute[0]);
            ch.truncate(offset);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int open(String path, StructFuseFileInfo info) {
        try {
            SeekableByteChannel channel = this.fsp.newByteChannel(this.path(path), FuseFileSystemProvider.fileInfoToOpenOptions(info), new FileAttribute[0]);
            long fh = this.fileHandle.incrementAndGet();
            this.openFiles.put(fh, channel);
            info.fh(fh);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int read(String path, ByteBuffer buffer, long size, long offset, StructFuseFileInfo info) {
        try {
            Channel channel = this.toChannel(info);
            if (channel instanceof SeekableByteChannel) {
                int n;
                SeekableByteChannel ch = (SeekableByteChannel)channel;
                if (info.nonseekable()) {
                    assert (offset == ch.position());
                } else {
                    ch.position(offset);
                }
                if ((n = ch.read(buffer)) > 0) {
                    if (!info.noblock()) {
                        assert (n <= 0 || (long)n == size);
                    } else {
                        int c;
                        while ((long)n < size && (c = ch.read(buffer)) > 0) {
                            n += c;
                        }
                    }
                }
                return n;
            }
            if (channel instanceof AsynchronousFileChannel) {
                AsynchronousFileChannel ch = (AsynchronousFileChannel)channel;
                int n = ch.read(buffer, offset).get();
                assert ((long)n == size);
                return n;
            }
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int write(String path, ByteBuffer buffer, long size, long offset, StructFuseFileInfo info) {
        try {
            Channel channel = this.toChannel(info);
            if (channel instanceof SeekableByteChannel) {
                int n;
                SeekableByteChannel ch = (SeekableByteChannel)channel;
                if (!info.append() && !info.nonseekable()) {
                    ch.position(offset);
                }
                if ((n = ch.write(buffer)) > 0) {
                    if (!info.noblock()) {
                        assert (n <= 0 || (long)n == size);
                    } else {
                        int c;
                        while ((long)n < size && (c = ch.write(buffer)) > 0) {
                            n += c;
                        }
                    }
                }
                return n;
            }
            if (channel instanceof AsynchronousFileChannel) {
                AsynchronousFileChannel ch = (AsynchronousFileChannel)channel;
                int n = ch.write(buffer, offset).get();
                return n;
            }
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int statfs(String path, StructStatvfs statvfs) {
        try {
            boolean hasStore = false;
            for (FileStore store : this.fs.getFileStores()) {
                if (hasStore) {
                    throw new IOException("Multiple FileStores not supported");
                }
                hasStore = true;
                long blockSize = 4096L;
                statvfs.bsize(4096L);
                statvfs.blocks(store.getTotalSpace() / 4096L);
                statvfs.bfree(store.getUnallocatedSpace() / 4096L);
                statvfs.bavail(store.getUsableSpace() / 4096L);
                long mountFlags = 0L;
                if (this.fs.isReadOnly()) {
                    mountFlags |= 1L;
                }
                statvfs.flags(mountFlags);
            }
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int flush(String path, StructFuseFileInfo info) {
        return 0;
    }

    @Override
    public int release(String path, StructFuseFileInfo info) {
        try {
            Channel ch = this.toChannel(info);
            ch.close();
            this.openFiles.remove(info.fh());
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int fsync(String path, int datasync, StructFuseFileInfo info) {
        try {
            Channel channel = this.toChannel(info);
            if (channel instanceof FileChannel) {
                FileChannel ch = (FileChannel)channel;
                ch.force(datasync == 0);
            } else if (channel instanceof AsynchronousFileChannel) {
                AsynchronousFileChannel ch = (AsynchronousFileChannel)channel;
                ch.force(true);
                ch.force(datasync == 0);
            } else {
                throw new UnsupportedOperationException();
            }
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int setxattr(String path, String xattr, ByteBuffer value, long size, int flags, int position) {
        return -Errno.ENOSYS.intValue();
    }

    @Override
    protected int getxattr(String path, String xattr, XattrFiller filler, long size, long position) {
        return -Errno.ENOSYS.intValue();
    }

    @Override
    protected int listxattr(String path, XattrListFiller filler) {
        return -Errno.ENOSYS.intValue();
    }

    @Override
    protected int removexattr(String path, String xattr) {
        return -Errno.ENOSYS.intValue();
    }

    @Override
    protected int opendir(String path, StructFuseFileInfo info) {
        try {
            DirectoryStream<Path> ds = this.fsp.newDirectoryStream(this.path(path), (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    return true;
                }
            });
            long fh = this.fileHandle.incrementAndGet();
            this.openFiles.put(fh, ds);
            info.fh(fh);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int readdir(String path, StructFuseFileInfo info, DirectoryFiller filler) {
        DirectoryStream ds = (DirectoryStream)this.openFiles.get(info.fh());
        filler.add(FuseFileSystemProvider.toStringIterable(ds));
        return 0;
    }

    @Override
    protected int releasedir(String path, StructFuseFileInfo info) {
        try {
            DirectoryStream ds = (DirectoryStream)this.openFiles.get(info.fh());
            ds.close();
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int fsyncdir(String path, int datasync, StructFuseFileInfo info) {
        return 0;
    }

    @Override
    protected void init() {
    }

    @Override
    protected void destroy() {
        try {
            this.fs.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected int access(String path, int access) {
        try {
            Path p = this.path(path);
            this.fsp.checkAccess(p, FuseFileSystemProvider.toAccessMode(access, Files.isDirectory(p, new LinkOption[0])));
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int create(String path, long mode, StructFuseFileInfo info) {
        try {
            Set<OpenOption> options = FuseFileSystemProvider.fileInfoToOpenOptions(info);
            options.add(StandardOpenOption.CREATE);
            SeekableByteChannel channel = this.fsp.newByteChannel(this.path(path), options, new FileAttribute[0]);
            long fh = this.fileHandle.incrementAndGet();
            this.openFiles.put(fh, channel);
            info.fh(fh);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int ftruncate(String path, long offset, StructFuseFileInfo info) {
        try {
            Channel channel = this.toChannel(info);
            if (channel instanceof SeekableByteChannel) {
                ((SeekableByteChannel)channel).truncate(offset);
            } else if (channel instanceof AsynchronousFileChannel) {
                ((AsynchronousFileChannel)channel).truncate(offset);
            }
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int fgetattr(String path, StructStat stat, StructFuseFileInfo info) {
        return this.getattr(path, stat);
    }

    @Override
    protected int lock(String path, StructFuseFileInfo info, int command, StructFlock flock) {
        try {
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int utimens(String path, StructTimeBuffer timeBuffer) {
        try {
            this.fsp.getFileAttributeView(this.path(path), BasicFileAttributeView.class, new LinkOption[0]).setTimes(FileTime.from(FuseFileSystemProvider.toNanos(timeBuffer.mod_sec(), timeBuffer.mod_nsec()), TimeUnit.NANOSECONDS), FileTime.from(FuseFileSystemProvider.toNanos(timeBuffer.ac_sec(), timeBuffer.ac_nsec()), TimeUnit.NANOSECONDS), null);
            return 0;
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    protected int bmap(String path, StructFuseFileInfo info) {
        try {
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            return -this.errno(e);
        }
    }

    @Override
    public int ioctl(String path, int cmd, Pointer arg, StructFuseFileInfo fi, long flags, Pointer data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int poll(String path, StructFuseFileInfo fi, StructFusePollHandle ph, Pointer reventsp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected int write_buf(String path, StructFuseBufvec buf, long off, StructFuseFileInfo fi) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected int read_buf(String path, Pointer bufp, long size, long off, StructFuseFileInfo fi) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int flock(String path, StructFuseFileInfo fi, int op) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int fallocate(String path, int mode, long off, long length, StructFuseFileInfo fi) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Channel toChannel(StructFuseFileInfo info) {
        return (Channel)this.openFiles.get(info.fh());
    }

    private static Set<OpenOption> fileInfoToOpenOptions(StructFuseFileInfo info) {
        HashSet<OpenOption> options = new HashSet<OpenOption>();
        if (info != null) {
            if (info.create()) {
                options.add(StandardOpenOption.CREATE);
            }
            if (info.append()) {
                options.add(StandardOpenOption.APPEND);
            }
            if (info.truncate()) {
                options.add(StandardOpenOption.TRUNCATE_EXISTING);
            }
            switch (info.openMode()) {
                case 0: {
                    options.add(StandardOpenOption.READ);
                    break;
                }
                case 1: {
                    options.add(StandardOpenOption.WRITE);
                    break;
                }
                case 2: {
                    options.add(StandardOpenOption.READ);
                    options.add(StandardOpenOption.WRITE);
                }
            }
        }
        return options;
    }

    private static Set<PosixFilePermission> modeToPermissions(long mode) {
        EnumSet<PosixFilePermission> permissions = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x100L) != 0L) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80L) != 0L) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40L) != 0L) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20L) != 0L) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10L) != 0L) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8L) != 0L) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4L) != 0L) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2L) != 0L) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1L) != 0L) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    private static long permissionsToMode(Set<PosixFilePermission> permissions) {
        long mode = 0L;
        for (PosixFilePermission px : permissions) {
            switch (px) {
                case OWNER_READ: {
                    mode |= 0x100L;
                    break;
                }
                case OWNER_WRITE: {
                    mode |= 0x80L;
                    break;
                }
                case OWNER_EXECUTE: {
                    mode |= 0x40L;
                    break;
                }
                case GROUP_READ: {
                    mode |= 0x20L;
                    break;
                }
                case GROUP_WRITE: {
                    mode |= 0x10L;
                    break;
                }
                case GROUP_EXECUTE: {
                    mode |= 8L;
                    break;
                }
                case OTHERS_READ: {
                    mode |= 4L;
                    break;
                }
                case OTHERS_WRITE: {
                    mode |= 2L;
                    break;
                }
                case OTHERS_EXECUTE: {
                    mode |= 1L;
                }
            }
        }
        return mode;
    }

    private static AccessMode[] toAccessMode(int access, boolean dir) {
        ArrayList<AccessMode> modes = new ArrayList<AccessMode>(3);
        if ((access & AccessConstants.R_OK) != 0 || dir && (access & AccessConstants.X_OK) != 0) {
            modes.add(AccessMode.READ);
        }
        if ((access & AccessConstants.W_OK) != 0) {
            modes.add(AccessMode.WRITE);
        }
        if (!dir && (access & AccessConstants.X_OK) != 0) {
            modes.add(AccessMode.EXECUTE);
        }
        return modes.toArray(new AccessMode[modes.size()]);
    }

    private static Iterable<String> toStringIterable(final Iterable<Path> iterable) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                final Iterator it = iterable.iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public String next() {
                        return ((Path)it.next()).toString();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private int errno(Throwable e) {
        Errno en = FuseFileSystemProvider.errno0(e);
        if (en == null) {
            return 0;
        }
        if (this.debug) {
            this.getLogger().log(Level.WARNING, "Exception", e);
        }
        return en.intValue();
    }

    private static Errno errno0(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof IllegalArgumentException) {
            return Errno.EINVAL;
        }
        if (t instanceof UnsupportedOperationException) {
            return Errno.ENOSYS;
        }
        if (t instanceof InterruptedException) {
            return Errno.EINTR;
        }
        if (t instanceof NullPointerException || t instanceof ClassCastException) {
            return Errno.EFAULT;
        }
        if (t instanceof SecurityException) {
            return Errno.EPERM;
        }
        if (t instanceof TimeoutException) {
            return Errno.ETIMEDOUT;
        }
        if (t instanceof AccessDeniedException) {
            return Errno.EACCES;
        }
        if (t instanceof FileAlreadyExistsException) {
            return Errno.EEXIST;
        }
        if (t instanceof FileNotFoundException || t instanceof NoSuchFileException) {
            return Errno.ENOENT;
        }
        if (t instanceof NotDirectoryException) {
            return Errno.ENOTDIR;
        }
        if (t instanceof DirectoryNotEmptyException) {
            return Errno.ENOTEMPTY;
        }
        if (t instanceof ReadOnlyFileSystemException) {
            return Errno.EROFS;
        }
        if (t instanceof IOException || t instanceof IOError) {
            return Errno.EIO;
        }
        return Errno.EFAULT;
    }

    private static void fillBufferWithString(String str, ByteBuffer buffer, long size) {
        byte[] bytes = str.getBytes();
        int s = (int)Math.min(Integer.MAX_VALUE, size - 1L);
        buffer.put(bytes, 0, Math.min(bytes.length, s));
        buffer.put((byte)0);
        buffer.flip();
    }

    private static long toNanos(long sec, long nanos) {
        return sec * 1000000000L + nanos;
    }

    private static long sec(FileTime ft) {
        return ft != null ? FuseFileSystemProvider.sec(ft.to(TimeUnit.NANOSECONDS)) : 0L;
    }

    private static long nsec(FileTime ft) {
        return ft != null ? FuseFileSystemProvider.nsec(ft.to(TimeUnit.NANOSECONDS)) : 0L;
    }

    private static long sec(long nanos) {
        return nanos / 1000000000L;
    }

    private static long nsec(long nanos) {
        return nanos % 1000000000L;
    }
}

