/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.javafs;

import co.paralleluniverse.fuse.Fuse;
import co.paralleluniverse.javafs.FuseFileSystemProvider;
import co.paralleluniverse.javafs.ReadOnlyFileSystem;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Map;

public final class JavaFS {
    public static void mount(FileSystem fs, Path mountPoint, boolean readonly, boolean log, Map<String, String> mountOptions) throws IOException {
        if (readonly) {
            fs = new ReadOnlyFileSystem(fs);
        }
        Fuse.mount(new FuseFileSystemProvider(fs, log).log(log), mountPoint, false, log, mountOptions);
    }

    public static void mount(FileSystem fs, Path mountPoint, boolean readonly, boolean log) throws IOException {
        JavaFS.mount(fs, mountPoint, readonly, log, null);
    }

    public static void mount(FileSystem fs, Path mountPoint, Map<String, String> mountOptions) throws IOException {
        JavaFS.mount(fs, mountPoint, false, false, mountOptions);
    }

    public static void mount(FileSystem fs, Path mountPoint) throws IOException {
        JavaFS.mount(fs, mountPoint, false, false, null);
    }

    public static void unmount(Path mountPoint) throws IOException {
        Fuse.unmount(mountPoint);
    }

    private JavaFS() {
    }
}

