/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.lang.reflect.AccessibleObject;
import java.util.Collection;
import java.util.Collections;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.mapper.CompositeTypeMapper;
import jnr.ffi.mapper.DefaultSignatureType;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.SignatureType;
import jnr.ffi.mapper.SignatureTypeMapper;
import jnr.ffi.provider.ClosureManager;
import jnr.ffi.provider.jffi.AsmClassLoader;
import jnr.ffi.provider.jffi.ClosureFromNativeConverter;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.SimpleNativeContext;

public class ClosureHelper {
    private final SimpleNativeContext ctx;
    private final ClassValue<FromNativeConverter<?, Pointer>> cache;

    public static ClosureHelper getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private ClosureHelper() {
        try {
            ClosureManager closureManager = Runtime.getSystemRuntime().getClosureManager();
            final AsmClassLoader cl = (AsmClassLoader)ClosureHelper.accessible(NativeClosureManager.class.getDeclaredField("classLoader")).get(closureManager);
            final CompositeTypeMapper ctm = (CompositeTypeMapper)ClosureHelper.accessible(NativeClosureManager.class.getDeclaredField("typeMapper")).get(closureManager);
            this.ctx = new SimpleNativeContext(Runtime.getSystemRuntime(), (Collection)Collections.EMPTY_LIST);
            this.cache = new ClassValue<FromNativeConverter<?, Pointer>>(){

                @Override
                protected FromNativeConverter<?, Pointer> computeValue(Class<?> closureClass) {
                    return ClosureFromNativeConverter.getInstance((Runtime)Runtime.getSystemRuntime(), (SignatureType)DefaultSignatureType.create(closureClass, (FromNativeContext)ClosureHelper.this.ctx), (AsmClassLoader)cl, (SignatureTypeMapper)ctm);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create helper", e);
        }
    }

    public <T> T fromNative(Pointer nativeValue, Class<T> closureClass) {
        return (T)this.cache.get(closureClass).fromNative((Object)nativeValue, (FromNativeContext)this.ctx);
    }

    public static <T> Pointer toNative(Class<? extends T> closureClass, T instance) {
        return Runtime.getSystemRuntime().getClosureManager().getClosurePointer(closureClass, instance);
    }

    private static <T extends AccessibleObject> T accessible(T obj) {
        obj.setAccessible(true);
        return obj;
    }

    private static class SingletonHolder {
        private static final ClosureHelper INSTANCE = new ClosureHelper();

        private SingletonHolder() {
        }
    }
}

