/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.ActorBuilder;
import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorLoader;
import co.paralleluniverse.actors.ActorMonitor;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorRegistry;
import co.paralleluniverse.actors.ActorRunner;
import co.paralleluniverse.actors.ActorSpec;
import co.paralleluniverse.actors.ActorUtil;
import co.paralleluniverse.actors.CodeSwap;
import co.paralleluniverse.actors.ConcurrencyException;
import co.paralleluniverse.actors.ExitMessage;
import co.paralleluniverse.actors.JMXActorMonitor;
import co.paralleluniverse.actors.LifecycleException;
import co.paralleluniverse.actors.LifecycleListener;
import co.paralleluniverse.actors.LifecycleMessage;
import co.paralleluniverse.actors.Mailbox;
import co.paralleluniverse.actors.MailboxConfig;
import co.paralleluniverse.actors.RemoteActor;
import co.paralleluniverse.actors.RemoteActorProxyFactoryService;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.concurrent.util.MapUtil;
import co.paralleluniverse.concurrent.util.ThreadAccess;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberFactory;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.Joinable;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.StrandFactory;
import co.paralleluniverse.strands.Stranded;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.ReceivePort;
import co.paralleluniverse.strands.channels.SendPort;
import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

@Instrumented
public abstract class Actor<Message, V>
extends ActorImpl<Message>
implements SuspendableCallable<V>,
ActorBuilder<Message, V>,
Joinable<V>,
Stranded,
ReceivePort<Message> {
    private static final Throwable NATURAL = new Throwable();
    private static final Object DEFUNCT = new Object();
    private static final ThreadLocal<Actor> currentActor = new ThreadLocal();
    private volatile transient ActorRef<Message> wrapperRef;
    private transient AtomicReference<Class<?>> classRef;
    private final Set<LifecycleListener> lifecycleListeners = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
    private final Set<ActorRef> observed = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
    private volatile V result;
    private volatile Throwable exception;
    private volatile Throwable deathCause;
    private volatile Object globalId;
    private volatile transient ActorMonitor monitor;
    private volatile boolean registered;
    private boolean hasMonitor;
    private ActorSpec<?, Message, V> spec;
    private Object aux;
    private ActorRunner<V> runner;
    private boolean migrating;
    private static final AtomicReferenceFieldUpdater<Actor, ActorRef> wrapperRefUpdater = AtomicReferenceFieldUpdater.newUpdater(Actor.class, ActorRef.class, "wrapperRef");
    private boolean forwardWatch;

    public static <T extends Actor<Message, V>, Message, V> T newActor(Class<T> clazz, Object ... params) {
        return Actor.newActor(ActorSpec.of(clazz, params));
    }

    public static <T extends Actor<Message, V>, Message, V> T newActor(ActorSpec<T, Message, V> spec) {
        return spec.build();
    }

    public Actor(String name, MailboxConfig mailboxConfig) {
        super(name, (SendPort<Object>)new Mailbox(mailboxConfig), new ActorRef());
        this.mailbox().setActor(this);
        this.runner = new ActorRunner(this.ref);
        this.classRef = ActorLoader.getClassRef(this.getClass());
        this.ref.setImpl(this);
    }

    protected Actor() {
        super(null, null, null);
        this.runner = new ActorRunner(this.ref);
        this.classRef = ActorLoader.getClassRef(this.getClass());
    }

    private void checkReplacement() {
        Actor impl = ActorLoader.getReplacementFor(this);
        this.ref.setImpl(impl);
        if (impl != this) {
            this.defunct();
        }
    }

    protected Actor(Strand strand, String name, MailboxConfig mailboxConfig) {
        this(name, mailboxConfig);
        if (strand != null) {
            this.runner.setStrand(strand);
        }
    }

    @Deprecated
    public Actor<Message, V> setForwardWatch(boolean value) {
        this.forwardWatch = value;
        return this;
    }

    void onCodeChange0() {
        this.ref.setImpl(this);
        this.record(1, "Actor", "onCodeChange", "%s", (Object)this);
        this.onCodeChange();
    }

    void defunct() {
        this.aux = DEFUNCT;
    }

    boolean isDefunct() {
        return this.aux == DEFUNCT;
    }

    protected ActorRef<Message> makeRef(ActorRef<Message> ref) {
        return ref;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    private ActorRef myRef() {
        return this.ref;
    }

    public ActorRef<Message> spawn(StrandFactory sf) {
        if (sf == null) {
            return this.spawn();
        }
        this.checkReplacement();
        Strand s = sf.newStrand(this.runner);
        this.setStrand(s);
        if (this.getName() != null) {
            s.setName(this.getName());
        }
        s.start();
        return this.ref();
    }

    public ActorRef<Message> spawn(FiberFactory ff) {
        if (ff == null) {
            return this.spawn();
        }
        this.checkReplacement();
        ff.newFiber(this.runner).setName(this.getName()).start();
        return this.ref();
    }

    public ActorRef<Message> spawn() {
        this.checkReplacement();
        Fiber f = this.getName() != null ? new Fiber(this.getName(), this.runner) : new Fiber(this.runner);
        f.start();
        return this.ref();
    }

    public ActorRef<Message> spawnThread() {
        this.checkReplacement();
        Runnable runnable = Strand.toRunnable(this.runner);
        Thread t = this.getName() != null ? new Thread(runnable, this.getName()) : new Thread(runnable);
        this.setStrand(Strand.of((Thread)t));
        t.start();
        return this.ref();
    }

    protected Actor<Message, V> reinstantiate() {
        if (this.spec != null) {
            return Actor.newActor(this.spec);
        }
        if (this.getClass().isAnonymousClass() && this.getClass().getSuperclass().equals(Actor.class)) {
            return Actor.newActor(this.createSpecForAnonymousClass());
        }
        throw new RuntimeException("Actor " + this + " cannot be reinstantiated");
    }

    private ActorSpec<Actor<Message, V>, Message, V> createSpecForAnonymousClass() {
        assert (this.getClass().isAnonymousClass() && this.getClass().getSuperclass().equals(Actor.class));
        Constructor<?> ctor = this.getClass().getDeclaredConstructors()[0];
        Object[] params = new Object[ctor.getParameterTypes().length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> type = ctor.getParameterTypes()[i];
            if (String.class.equals(type)) {
                params[i] = this.getName();
            }
            params[i] = Integer.TYPE.equals(type) ? Integer.valueOf(this.mailbox().capacity()) : (type.isPrimitive() ? Integer.valueOf(0) : null);
        }
        return new ActorSpec(ctor, params);
    }

    void setSpec(ActorSpec<?, Message, V> spec) {
        this.spec = spec;
    }

    Object getAux() {
        return this.aux;
    }

    void setAux(Object aux) {
        this.verifyInActor();
        this.aux = aux;
    }

    @Override
    public String toString() {
        Strand strand;
        String className = this.getClass().getSimpleName();
        if (className.isEmpty()) {
            className = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
        }
        String strandName = (strand = this.runner.getStrand()) != null ? strand.getName() : "null";
        return className + "@" + (this.getName() != null ? this.getName() : Integer.toHexString(System.identityHashCode(this))) + "[owner: " + strandName + "]";
    }

    private static String systemToStringWithSimpleName(Object obj) {
        return obj == null ? "null" : obj.getClass().getSimpleName() + "@" + Objects.systemObjectId((Object)obj);
    }

    @Override
    protected final void interrupt() {
        this.getStrand().interrupt();
    }

    public static <M, V> Actor<M, V> currentActor() {
        Fiber currentFiber = Fiber.currentFiber();
        if (currentFiber == null) {
            return currentActor.get();
        }
        SuspendableCallable target = currentFiber.getTarget();
        if (target == null) {
            return null;
        }
        if (target instanceof Actor) {
            return (Actor)target;
        }
        if (target instanceof ActorRunner) {
            return ((ActorRunner)target).getActor();
        }
        return null;
    }

    @Override
    public ActorRef<Message> ref() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Actor has not been started");
        }
        return this.ref0();
    }

    ActorRef<Message> ref0() {
        if (this.wrapperRef == null) {
            wrapperRefUpdater.compareAndSet(this, null, this.makeRef(this.ref));
        }
        return this.wrapperRef;
    }

    protected ActorRef<Message> self() {
        return this.ref();
    }

    public final void setStrand(Strand strand) {
        this.runner.setStrand(strand);
    }

    void setStrand0(Strand strand) {
        this.mailbox().setStrand(strand);
    }

    public final Strand getStrand() {
        return this.runner.getStrand();
    }

    public final int getQueueLength() {
        return this.mailbox().getQueueLength();
    }

    protected final Mailbox<Object> mailbox() {
        return (Mailbox)super.mailbox();
    }

    @Override
    protected void internalSend(Object message) {
        this.internalSendNonSuspendable(message);
    }

    @Override
    protected void internalSendNonSuspendable(Object message) {
        this.record(1, "Actor", "send", "Sending %s -> %s", message, (Object)this);
        if (Debug.isDebug() && this.flightRecorder != null && this.flightRecorder.get().recordsLevel(2)) {
            this.record(2, "Actor", "send", "%s queue %s", (Object)this, (Object)this.getQueueLength());
        }
        if (this.mailbox().isOwnerAlive()) {
            this.mailbox().sendNonSuspendable(message);
        } else {
            this.record(1, "Actor", "send", "Message dropped. Owner not alive.");
        }
    }

    @Override
    protected final boolean trySend(Message message) {
        this.record(1, "Actor", "trySend", "Sending %s -> %s", (Object)message, (Object)this);
        if (Debug.isDebug() && this.flightRecorder != null && this.flightRecorder.get().recordsLevel(2)) {
            this.record(2, "Actor", "trySend", "%s queue %s", (Object)this, (Object)this.getQueueLength());
        }
        if (this.mailbox().isOwnerAlive()) {
            if (this.mailbox().trySend(message)) {
                return true;
            }
            this.record(1, "Actor", "trySend", "Message not sent. Mailbox is not ready.");
            return false;
        }
        this.record(1, "Actor", "trySend", "Message dropped. Owner not alive.");
        return true;
    }

    public final Message tryReceive() {
        Object m;
        Message msg;
        do {
            this.checkThrownIn0();
            m = this.mailbox().tryReceive();
            if (m == null) {
                return null;
            }
            this.record(1, "Actor", "tryReceive", "Received %s <- %s", (Object)this, m);
            this.monitorAddMessage();
        } while ((msg = this.filterMessage(m)) == null);
        return msg;
    }

    protected Message filterMessage(Object m) {
        if (m instanceof LifecycleMessage) {
            return this.handleLifecycleMessage((LifecycleMessage)m);
        }
        return (Message)m;
    }

    public final boolean isClosed() {
        return this.mailbox().isClosed();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    public final Actor<Message, V> start() {
        this.record(1, "Actor", "start", "Starting actor %s", (Object)this);
        this.runner.getStrand().start();
        return this;
    }

    V getResult() throws ExecutionException {
        if (this.exception == null) {
            return this.result;
        }
        throw new ExecutionException(this.exception);
    }

    Throwable getDeathCause0() {
        return this.deathCause;
    }

    public final V get() throws InterruptedException, ExecutionException {
        return this.runner.get();
    }

    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.runner.get(timeout, unit);
    }

    public final boolean isStarted() {
        return this.runner == null || this.runner.isStarted();
    }

    public final boolean isDone() {
        return this.runner.isDone();
    }

    protected final void verifyInActor() {
        if (!this.isInActor()) {
            throw new ConcurrencyException("Operation not called from within the actor (" + this + ", but called in " + Actor.currentActor() + ")");
        }
    }

    protected final void verifyOnActorStrand() {
        if (!Strand.currentStrand().equals(this.getStrand())) {
            throw new ConcurrencyException("Operation not called from within the actor's strand (" + this.getStrand() + ", but called in " + Strand.currentStrand() + ")");
        }
    }

    protected final boolean isInActor() {
        return Actor.currentActor() == this;
    }

    public static Actor getActor(Strand s) {
        ActorRunner runner = s.isFiber() ? (ActorRunner)((Fiber)s.getUnderlying()).getTarget() : (ActorRunner)Strand.unwrapSuspendable((Runnable)ThreadAccess.getTarget((Thread)((Thread)s.getUnderlying())));
        if (runner == null) {
            return null;
        }
        return runner.getActor();
    }

    protected abstract V doRun() throws InterruptedException, SuspendExecution;

    protected Message handleLifecycleMessage(LifecycleMessage m) {
        this.record(1, "Actor", "handleLifecycleMessage", "%s got LifecycleMessage %s", (Object)this, (Object)m);
        if (m instanceof ExitMessage) {
            ExitMessage exit = (ExitMessage)m;
            this.removeObserverListeners(exit.getActor());
            if (!this.observed.remove(exit.getActor())) {
                return null;
            }
            if (exit.getWatch() == null) {
                throw new LifecycleException(m);
            }
            if (this.forwardWatch) {
                return (Message)m;
            }
        }
        return null;
    }

    protected void onCodeChange() {
    }

    @Override
    protected final void addLifecycleListener(LifecycleListener listener) {
        Throwable cause = this.getDeathCause();
        if (this.isDone()) {
            listener.dead(this.ref, cause);
            return;
        }
        this.lifecycleListeners.add(listener);
        if (this.isDone()) {
            listener.dead(this.ref, cause);
        }
    }

    @Override
    protected void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    @Override
    protected void removeObserverListeners(ActorRef actor) {
        Iterator<LifecycleListener> it = this.lifecycleListeners.iterator();
        while (it.hasNext()) {
            LifecycleListener lifecycleListener = it.next();
            if (!(lifecycleListener instanceof ActorImpl.ActorLifecycleListener) || !((ActorImpl.ActorLifecycleListener)lifecycleListener).getObserver().equals(actor)) continue;
            it.remove();
        }
    }

    protected final Throwable getDeathCause() {
        return this.deathCause == NATURAL ? null : this.deathCause;
    }

    public final boolean isRegistered() {
        return this.registered;
    }

    Object getGlobalId() {
        return this.globalId;
    }

    void setGlobalId(Object globalId) {
        this.globalId = globalId;
    }

    @Override
    public final void throwIn(RuntimeException e) {
        this.record(1, "Actor", "throwIn", "Exception %s thrown into actor %s", (Object)e, (Object)this);
        this.exception = e;
        this.runner.getStrand().interrupt();
    }

    public final void checkThrownIn() {
        this.verifyOnActorStrand();
        this.checkThrownIn0();
    }

    final void checkThrownIn0() {
        if (this.exception != null) {
            if (this.isRecordingLevel(1)) {
                this.record(1, "Actor", "checkThrownIn", "%s detected thrown in exception %s - %s", (Object)this, (Object)this.exception, (Object)Arrays.toString(this.exception.getStackTrace()));
            }
            this.exception.setStackTrace(new Throwable().getStackTrace());
            throw (RuntimeException)this.exception;
        }
    }

    public final Actor link(ActorRef other) {
        ActorImpl other1 = Actor.getActorRefImpl(other);
        this.record(1, "Actor", "link", "Linking actors %s, %s", (Object)this, (Object)other1);
        this.linked(other);
        other1.linked(this.myRef());
        return this;
    }

    @Override
    protected void linked(ActorRef actor) {
        if (!this.isDone()) {
            this.observed.add(actor);
        }
        this.addLifecycleListener(Actor.getActorRefImpl(actor).getLifecycleListener());
    }

    public final Actor unlink(ActorRef other) {
        ActorImpl other1 = Actor.getActorRefImpl(other);
        this.record(1, "Actor", "unlink", "Uninking actors %s, %s", (Object)this, (Object)other1);
        this.observed.remove(other);
        this.removeLifecycleListener(other1.getLifecycleListener());
        other1.unlinked(this.myRef());
        return this;
    }

    @Override
    protected void unlinked(ActorRef actor) {
        this.observed.remove(actor);
        this.removeLifecycleListener(Actor.getActorRefImpl(actor).getLifecycleListener());
    }

    public final Object watch(ActorRef other) {
        Object id = ActorUtil.randtag();
        ActorImpl.ActorLifecycleListener listener = new ActorImpl.ActorLifecycleListener(this.myRef(), id);
        this.record(1, "Actor", "watch", "Actor %s to watch %s (listener: %s)", (Object)this, (Object)other, (Object)listener);
        ActorImpl other1 = Actor.getActorRefImpl(other);
        this.observed.add(other);
        other1.addLifecycleListener(listener);
        return id;
    }

    public final void unwatch(ActorRef other, Object watchId) {
        ActorImpl.ActorLifecycleListener listener = new ActorImpl.ActorLifecycleListener(this.myRef(), watchId);
        this.record(1, "Actor", "unwatch", "Actor %s to stop watching %s (listener: %s)", (Object)this, (Object)other, (Object)listener);
        ActorImpl other1 = Actor.getActorRefImpl(other);
        this.observed.remove(other);
        other1.removeLifecycleListener(listener);
    }

    void postRegister() {
        this.registered = true;
    }

    public final Actor unregister() {
        if (!this.isRegistered()) {
            return this;
        }
        this.record(1, "Actor", "unregister", "Unregistering actor %s (name: %s)", (Object)this, (Object)this.getName());
        if (this.getName() == null) {
            throw new IllegalArgumentException("name is null");
        }
        ActorRegistry.unregister(this);
        this.stopMonitor();
        this.registered = false;
        return this;
    }

    private void die(Throwable cause) {
        this.record(1, "Actor", "die", "Actor %s is dying of cause %s", (Object)this, (Object)cause);
        this.deathCause = cause == null ? NATURAL : cause;
        this.monitorAddDeath(cause);
        if (this.isRegistered()) {
            this.unregister();
        }
        for (LifecycleListener listener : this.lifecycleListeners) {
            this.record(1, "Actor", "die", "Actor %s notifying listener %s of death.", (Object)this, (Object)listener);
            try {
                listener.dead(this.ref, cause);
            }
            catch (Exception e) {
                this.record(1, "Actor", "die", "Actor %s notifying listener %s of death failed with excetpion %s", (Object)this, (Object)listener, (Object)e);
            }
        }
        this.lifecycleListeners.clear();
        for (ActorRef a : this.observed) {
            Actor.getActorRefImpl(a).removeObserverListeners(this.myRef());
        }
        this.observed.clear();
    }

    boolean isMigrating() {
        return this.migrating;
    }

    private void preMigrate() {
        if (this.monitor != null) {
            this.hasMonitor = true;
            this.stopMonitor();
        }
        this.ref.setImpl(RemoteActorProxyFactoryService.create(this.ref, this.getGlobalId()));
    }

    private void postMigrate() {
        Object m;
        assert (this.ref.getImpl() instanceof RemoteActor);
        Mailbox<Object> mbox = this.mailbox();
        while ((m = mbox.tryReceive()) != null) {
            this.ref.getImpl().internalSendNonSuspendable(m);
        }
    }

    protected final Object writeReplace() throws ObjectStreamException {
        if (this.migrating) {
            return this;
        }
        RemoteActor<Message> remote = RemoteActorProxyFactoryService.create(this.ref(), this.getGlobalId());
        return remote;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.classRef = ActorLoader.getClassRef(this.getClass());
        this.mailbox().setActor(this);
        if (this.hasMonitor) {
            this.monitor();
        }
        return this;
    }

    public final ActorMonitor monitor() {
        if (this.monitor != null) {
            return this.monitor;
        }
        String name = this.getName().replaceAll(":", "");
        this.monitor = new JMXActorMonitor(name);
        this.monitor.setActor(this.ref);
        return this.monitor;
    }

    public final void setMonitor(ActorMonitor monitor) {
        if (this.monitor == monitor) {
            return;
        }
        if (this.monitor != null) {
            throw new RuntimeException("actor already has a monitor");
        }
        this.monitor = monitor;
        monitor.setActor(this.ref);
    }

    public final void stopMonitor() {
        if (this.monitor != null) {
            this.monitor.shutdown();
            this.monitor = null;
        }
    }

    public final ActorMonitor getMonitor() {
        return this.monitor;
    }

    protected final void monitorAddDeath(Object reason) {
        if (this.monitor != null) {
            this.monitor.addDeath(reason);
        }
    }

    protected final void monitorAddMessage() {
        if (this.monitor != null) {
            this.monitor.addMessage();
        }
    }

    protected final void monitorSkippedMessage() {
        if (this.monitor != null) {
            this.monitor.skippedMessage();
        }
    }

    protected final void monitorResetSkippedMessages() {
        if (this.monitor != null) {
            this.monitor.resetSkippedMessages();
        }
    }

    List<Object> getMailboxSnapshot() {
        return this.mailbox().getSnapshot();
    }

    StackTraceElement[] getStackTrace() {
        return this.runner.getStrand().getStackTrace();
    }

    static /* synthetic */ void access$000(Actor x0) {
        x0.postMigrate();
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=277, methodEnd=278, suspendableCallSites={278}, suspendableCallSiteNames={"co/paralleluniverse/actors/ActorRunner.run()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={80})
    public final V run() throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=444, methodEnd=451, suspendableCallSites={448}, suspendableCallSiteNames={"co/paralleluniverse/actors/Mailbox.sendSync(Ljava/lang/Object;)V"}, suspendableCallSitesOffsetsAfterInstr={168})
    protected final void sendSync(Message var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=479, methodEnd=492, suspendableCallSites={481}, suspendableCallSiteNames={"co/paralleluniverse/actors/Mailbox.receive()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={94})
    public final Message receive() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=507, methodEnd=541, suspendableCallSites={508, 520}, suspendableCallSiteNames={"co/paralleluniverse/actors/Mailbox.receive(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "co/paralleluniverse/actors/Actor.receive()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={124, 342})
    public final Message receive(long var1_1, TimeUnit var3_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=555, methodEnd=555, suspendableCallSites={555}, suspendableCallSiteNames={"co/paralleluniverse/actors/Actor.receive(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={118})
    public final Message receive(Timeout var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=638, methodEnd=639, suspendableCallSites={638}, suspendableCallSiteNames={"co/paralleluniverse/actors/ActorRunner.join()V"}, suspendableCallSitesOffsetsAfterInstr={76})
    public final void join() throws ExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(methodOptimized=false, methodStart=644, methodEnd=645, suspendableCallSites={644}, suspendableCallSiteNames={"co/paralleluniverse/actors/ActorRunner.join(JLjava/util/concurrent/TimeUnit;)V"}, suspendableCallSitesOffsetsAfterInstr={148})
    public final void join(long var1_1, TimeUnit var3_2) throws ExecutionException, InterruptedException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=702, methodEnd=740, suspendableCallSites={708, 710}, suspendableCallSiteNames={"co/paralleluniverse/actors/MigrationService.registerMigratingActor()Ljava/lang/Object;", "co/paralleluniverse/actors/Actor.doRun()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={152, 222})
    final V run0() throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented(methodOptimized=true, methodStart=791, methodEnd=798, suspendableCallSites={}, suspendableCallSiteNames={}, suspendableCallSitesOffsetsAfterInstr={})
    protected void checkCodeSwap() throws SuspendExecution {
        if (this.classRef == null) {
            return;
        }
        this.verifyInActor();
        if (this.classRef.get() != this.getClass()) {
            this.record(1, "Actor", "checkCodeSwap", "Code swap detected for %s", (Object)this);
            throw CodeSwap.CODE_SWAP;
        }
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=988, methodEnd=992, suspendableCallSites={991, 992}, suspendableCallSiteNames={"-.makeConcatWithConstants(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "co/paralleluniverse/actors/Actor.register()Lco/paralleluniverse/actors/Actor;"}, suspendableCallSitesOffsetsAfterInstr={135, 193})
    public final Actor<Message, V> register(String var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=997, methodEnd=1004, suspendableCallSites={1000, 1003}, suspendableCallSiteNames={"-.makeConcatWithConstants(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "co/paralleluniverse/actors/MigrationService.registerMigratingActor()Ljava/lang/Object;"}, suspendableCallSitesOffsetsAfterInstr={135, 228})
    void preRegister(String var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1017, methodEnd=1021, suspendableCallSites={1020}, suspendableCallSiteNames={"co/paralleluniverse/actors/ActorRegistry.register(Lco/paralleluniverse/actors/Actor;)V"}, suspendableCallSitesOffsetsAfterInstr={109})
    public final Actor register() throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1078, methodEnd=1090, suspendableCallSites={1085}, suspendableCallSiteNames={"co/paralleluniverse/actors/MigrationService.migrate(Ljava/lang/Object;Lco/paralleluniverse/actors/Actor;[B)V"}, suspendableCallSitesOffsetsAfterInstr={139})
    public void migrateAndRestart() throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1100, methodEnd=1121, suspendableCallSites={1105}, suspendableCallSiteNames={"co/paralleluniverse/fibers/Fiber.parkAndSerialize(Lco/paralleluniverse/fibers/FiberWriter;)V"}, suspendableCallSitesOffsetsAfterInstr={82})
    public void migrate() throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1154, methodEnd=1154, suspendableCallSites={1154}, suspendableCallSiteNames={"co/paralleluniverse/actors/Actor.hire(Lco/paralleluniverse/actors/ActorRef;Lco/paralleluniverse/fibers/FiberScheduler;)Lco/paralleluniverse/actors/ActorRef;"}, suspendableCallSitesOffsetsAfterInstr={104})
    public static <M> ActorRef<M> hire(ActorRef<M> var0) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=1166, methodEnd=1186, suspendableCallSites={1166, 1175}, suspendableCallSiteNames={"co/paralleluniverse/actors/MigrationService.hire(Lco/paralleluniverse/actors/ActorRef;Lco/paralleluniverse/io/serialization/ByteArraySerializer;)Lco/paralleluniverse/actors/Actor;", "-.makeConcatWithConstants(Lco/paralleluniverse/actors/ActorRef;Lco/paralleluniverse/actors/ActorRef;)Ljava/lang/String;"}, suspendableCallSitesOffsetsAfterInstr={141, 326})
    public static <M> ActorRef<M> hire(ActorRef<M> var0, FiberScheduler var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=1194, methodEnd=1206, suspendableCallSites={1195, 1204, 1205}, suspendableCallSiteNames={"-.makeConcatWithConstants(Lco/paralleluniverse/actors/Actor;)Ljava/lang/String;", "co/paralleluniverse/actors/ActorRegistry.tryGetActor(Ljava/lang/String;)Lco/paralleluniverse/actors/ActorRef;", "co/paralleluniverse/actors/Actor.register()Lco/paralleluniverse/actors/Actor;"}, suspendableCallSitesOffsetsAfterInstr={88, 206, 253})
    public final Actor<Message, V> build() throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

