/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorLoaderMXBean;
import co.paralleluniverse.actors.ActorModule;
import co.paralleluniverse.actors.InstanceUpgrader;
import co.paralleluniverse.common.reflection.ClassLoaderUtil;
import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.concurrent.util.MapUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActorLoader
extends ClassLoader
implements ActorLoaderMXBean,
NotificationEmitter {
    private static final String MODULE_DIR_PROPERTY = "co.paralleluniverse.actors.moduleDir";
    private static final Path moduleDir;
    private static final Logger LOG;
    private static final ActorLoader instance;
    private final ConcurrentMap<String, AtomicReference<Class<?>>> classRefs = MapUtil.newConcurrentHashMap();
    private final ClassValue<AtomicReference<Class<?>>> classRefs1 = new ClassValue<AtomicReference<Class<?>>>(){

        @Override
        protected AtomicReference<Class<?>> computeValue(Class<?> type) {
            return ActorLoader.this.getClassRef0(type.getName());
        }
    };
    private final List<ActorModule> modules = new CopyOnWriteArrayList<ActorModule>();
    private final ConcurrentMap<String, ActorModule> classModule = MapUtil.newConcurrentHashMap();
    private final ThreadLocal<Boolean> recursive = new ThreadLocal();
    private final NotificationBroadcasterSupport notificationBroadcaster;
    private int notificationSequenceNumber;

    public static <T> Class<T> currentClassFor(Class<T> clazz) {
        return instance.getCurrentClassFor(clazz);
    }

    public static Class<?> currentClassFor(String className) throws ClassNotFoundException {
        return instance.getCurrentClassFor(className);
    }

    public static <T> T getReplacementFor(T object) {
        return instance.getReplacementFor0(object);
    }

    static AtomicReference<Class<?>> getClassRef(String className) {
        return instance.getClassRef0(className);
    }

    static AtomicReference<Class<?>> getClassRef(Class<?> clazz) {
        return instance.getClassRef0(clazz);
    }

    private ActorLoader(String mbeanName) {
        super(ActorLoader.class.getClassLoader());
        MBeanNotificationInfo info = new MBeanNotificationInfo(new String[]{"co.paralleluniverse.actors.module"}, ModuleNotification.class.getName(), "Actor module change");
        this.notificationBroadcaster = new NotificationBroadcasterSupport(info);
        try {
            this.registerMBean(mbeanName);
        }
        catch (InstanceAlreadyExistsException e) {
            try {
                this.registerMBean(mbeanName + ",instance=" + Integer.toHexString(System.identityHashCode(ActorLoader.class.getClassLoader())));
            }
            catch (InstanceAlreadyExistsException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void registerMBean(String mbeanName) throws InstanceAlreadyExistsException {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(mbeanName);
            mbs.registerMBean(this, mxbeanName);
        }
        catch (MBeanRegistrationException ex) {
            LOG.error("exception while registering MBean " + mbeanName, (Throwable)ex);
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private ActorModule getModule(URL url) {
        for (ActorModule m : this.modules) {
            if (!m.getURL().equals(url)) continue;
            return m;
        }
        return null;
    }

    private Map<String, Class<?>> checkModule(ActorModule module) {
        HashMap oldClasses = new HashMap();
        try {
            for (String className : module.getUpgradeClasses()) {
                Class<?> newClass = null;
                try {
                    newClass = module.loadClassInModule(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Upgraded class " + className + " is not found in module " + module);
                }
                Class<?> oldClass = null;
                try {
                    oldClass = this.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Upgraded class " + className + " does not upgrade an existing class");
                }
                oldClasses.put(className, oldClass);
            }
            return oldClasses;
        }
        catch (Exception e) {
            LOG.error("Error while loading module " + module, (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<String> getLoadedModules() {
        return Lists.transform(this.modules, (Function)new Function<ActorModule, String>(){

            public String apply(ActorModule module) {
                return module.getURL().toString();
            }
        });
    }

    @Override
    public synchronized void reloadModule(String jarURL) {
        try {
            this.reloadModule(new URL(jarURL));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized void loadModule(String jarURL) {
        try {
            this.loadModule(new URL(jarURL));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public synchronized void unloadModule(String jarURL) {
        try {
            this.unloadModule(new URL(jarURL));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized void reloadModule(URL jarURL) {
        ActorModule oldModule = this.getModule(jarURL);
        LOG.info("{} module {}.", (Object)(oldModule == null ? "Loading" : "Reloading"), (Object)jarURL);
        ActorModule module = new ActorModule(jarURL, this);
        this.addModule(module);
        if (oldModule != null) {
            this.removeModule(oldModule);
        }
        LOG.info("Module {} {}.", (Object)jarURL, (Object)(oldModule == null ? "loaded" : "reloaded"));
        this.notify(module, oldModule == null ? "loaded" : "reloaded");
    }

    public synchronized void loadModule(URL jarURL) {
        if (this.getModule(jarURL) != null) {
            LOG.warn("loadModule: module {} already loaded.", (Object)jarURL);
            return;
        }
        LOG.info("Loading module {}.", (Object)jarURL);
        ActorModule module = new ActorModule(jarURL, this);
        this.addModule(module);
        LOG.info("Module {} loaded.", (Object)jarURL);
        this.notify(module, "loaded");
    }

    public synchronized void unloadModule(URL jarURL) {
        ActorModule module = this.getModule(jarURL);
        if (module == null) {
            LOG.warn("removeModule: module {} not loaded.", (Object)jarURL);
            return;
        }
        LOG.info("Removing module {}.", (Object)jarURL);
        this.removeModule(module);
        LOG.info("Module {} removed.", (Object)jarURL);
        this.notify(module, "removed");
    }

    private synchronized void addModule(ActorModule module) {
        Map<String, Class<?>> oldClasses = this.checkModule(module);
        this.modules.add(module);
        for (String className : module.getUpgradeClasses()) {
            Class<?> oldClass;
            try {
                Class<?> newClass = module.loadClass(className);
                oldClass = oldClasses.get(className);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError();
            }
            LOG.info("Upgrading class {} of module {} to that in module {}", new Object[]{className, ActorLoader.getModule(oldClass), module});
            this.classModule.put(className, module);
        }
        this.performUpgrade(new HashSet(oldClasses.values()));
    }

    private synchronized void removeModule(ActorModule module) {
        this.modules.remove(module);
        HashSet oldClasses = new HashSet();
        for (String className : module.getUpgradeClasses()) {
            Class<?> oldClass;
            if (this.classModule.get(className) != module) continue;
            ActorModule newModule = null;
            for (ActorModule m : Lists.reverse(this.modules)) {
                if (!m.getUpgradeClasses().contains(className)) continue;
                newModule = m;
                break;
            }
            LOG.info("Downgrading class {} of module {} to that in module {}", new Object[]{className, module, newModule});
            if (newModule != null) {
                this.classModule.put(className, newModule);
            } else {
                this.classModule.remove(className);
            }
            if ((oldClass = module.findLoadedClassInModule(className)) == null) continue;
            oldClasses.add(oldClass);
        }
        this.performUpgrade(oldClasses);
    }

    private void performUpgrade(Set<Class<?>> oldClasses) {
        for (Class<?> oldClass : oldClasses) {
            try {
                LOG.debug("Triggering replacement of {} ({})", oldClass, (Object)ActorLoader.getModule(oldClass));
                this.getClassRef0(oldClass).set(this.loadCurrentClass(oldClass.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static ActorModule getModule(Class<?> clazz) {
        return clazz.getClassLoader() instanceof ActorModule ? (ActorModule)clazz.getClassLoader() : null;
    }

    <T extends Actor<?, ?>> Class<T> loadCurrentClass(String className) throws ClassNotFoundException {
        ActorModule module = (ActorModule)this.classModule.get(className);
        Class<?> clazz = module != null ? module.loadClass(className) : this.getParent().loadClass(className);
        LOG.debug("currentClassFor {} - {} {}", new Object[]{className, ActorLoader.getModule(clazz), module});
        return clazz;
    }

    <T> T getReplacementFor0(T instance) {
        if (instance == null) {
            return null;
        }
        Class<?> clazz = instance.getClass();
        if (clazz.isAnonymousClass()) {
            return instance;
        }
        Class<?> newClazz = this.getCurrentClassFor(clazz);
        if (newClazz == clazz) {
            return instance;
        }
        return (T)InstanceUpgrader.get(newClazz).copy(instance);
    }

    <T> Class<T> getCurrentClassFor(Class<T> clazz) {
        if (clazz.isAnonymousClass()) {
            return clazz;
        }
        AtomicReference<Class<?>> ref = this.getClassRef0(clazz);
        Class<Object> clazz1 = ref.get();
        if (clazz1 == null) {
            try {
                clazz1 = this.loadCurrentClass(clazz.getName());
            }
            catch (ClassNotFoundException e) {
                clazz1 = clazz;
            }
            if (!ref.compareAndSet(null, clazz1)) {
                clazz1 = ref.get();
            }
        }
        assert (clazz1 != null);
        return clazz1;
    }

    Class<?> getCurrentClassFor(String className) throws ClassNotFoundException {
        AtomicReference<Class<?>> ref = this.getClassRef0(className);
        Class<Object> clazz = ref.get();
        if (clazz == null && !ref.compareAndSet(null, clazz = this.loadCurrentClass(className))) {
            clazz = ref.get();
        }
        assert (clazz != null);
        return clazz;
    }

    AtomicReference<Class<?>> getClassRef0(Class<?> clazz) {
        if (clazz.isAnonymousClass()) {
            return null;
        }
        return this.classRefs1.get(clazz);
    }

    AtomicReference<Class<?>> getClassRef0(String className) {
        AtomicReference newValue = new AtomicReference();
        AtomicReference<Class<?>> oldValue = this.classRefs.putIfAbsent(className, newValue);
        return oldValue != null ? oldValue : newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.recursive.get() == Boolean.TRUE) {
            throw new ClassNotFoundException(name);
        }
        this.recursive.set(Boolean.TRUE);
        try {
            ActorModule module = (ActorModule)this.classModule.get(name);
            if (module != null) {
                Class<?> clazz = module.loadClassInModule(name);
                return clazz;
            }
        }
        finally {
            this.recursive.remove();
        }
        return this.getParent().loadClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        if (this.recursive.get() == Boolean.TRUE) {
            return null;
        }
        this.recursive.set(Boolean.TRUE);
        try {
            String className;
            ActorModule module;
            if (ClassLoaderUtil.isClassFile((String)name) && (module = (ActorModule)this.classModule.get(className = ClassLoaderUtil.resourceToClass((String)name))) != null) {
                URL uRL = module.getResource(name);
                return uRL;
            }
        }
        finally {
            this.recursive.remove();
        }
        return super.getResource(name);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notificationBroadcaster.getNotificationInfo();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.notificationBroadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener);
    }

    private synchronized void notify(ActorModule module, String action) {
        ModuleNotification n = new ModuleNotification(this, this.notificationSequenceNumber++, System.currentTimeMillis(), "Module " + module + " has been " + action);
        this.notificationBroadcaster.sendNotification(n);
    }

    private static void loadModulesInModuleDir(ActorLoader instance, Path moduleDir) {
        LOG.info("scanning module directory " + moduleDir + " for modules.");
        try (DirectoryStream<Path> children = Files.newDirectoryStream(moduleDir);){
            for (Path child : children) {
                if (ActorLoader.isValidFile(child, false)) {
                    try {
                        URL jarUrl = child.toUri().toURL();
                        instance.reloadModule(jarUrl);
                    }
                    catch (Exception e) {
                        LOG.error("exception while processing " + child, (Throwable)e);
                    }
                    continue;
                }
                LOG.warn("A non-jar item " + child.getFileName() + " found in the modules directory " + moduleDir);
            }
        }
        catch (Exception e) {
            LOG.error("exception while loading modules in module directory " + moduleDir, (Throwable)e);
        }
    }

    private static void monitorFilesystem(ActorLoader instance, Path moduleDir) {
        try {
            WatchService watcher = FileSystems.getDefault().newWatchService();
            try {
                WatchKey key;
                moduleDir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                LOG.info("Filesystem monitor: Watching module directory " + moduleDir + " for changes.");
                do {
                    key = watcher.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            LOG.warn("Filesystem monitor: filesystem events may have been missed");
                            continue;
                        }
                        WatchEvent<?> ev = event;
                        Path filename = (Path)ev.context();
                        Path child = moduleDir.resolve(filename);
                        if (ActorLoader.isValidFile(child, kind == StandardWatchEventKinds.ENTRY_DELETE)) {
                            try {
                                URL jarUrl = child.toUri().toURL();
                                LOG.info("Filesystem monitor: detected module file {} {}", (Object)child, (Object)(kind == StandardWatchEventKinds.ENTRY_CREATE ? "created" : (kind == StandardWatchEventKinds.ENTRY_MODIFY ? "modified" : (kind == StandardWatchEventKinds.ENTRY_DELETE ? "deleted" : null))));
                                if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                                    instance.reloadModule(jarUrl);
                                    continue;
                                }
                                if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                                instance.unloadModule(jarUrl);
                            }
                            catch (Exception e) {
                                LOG.error("Filesystem monitor: exception while processing " + child, (Throwable)e);
                            }
                            continue;
                        }
                        if (kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                        LOG.warn("Filesystem monitor: A non-jar item " + child.getFileName() + " has been placed in the modules directory " + moduleDir);
                    }
                } while (key.reset());
                throw new IOException("Directory " + moduleDir + " is no longer accessible");
            }
            catch (Throwable throwable) {
                if (watcher != null) {
                    try {
                        watcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.error("Filesystem monitor thread terminated with an exception", (Throwable)e);
            throw Exceptions.rethrow((Throwable)e);
        }
    }

    private static boolean isValidFile(Path file, boolean delete) {
        return (delete || Files.isRegularFile(file, new LinkOption[0])) && file.getFileName().toString().endsWith(".jar");
    }

    static {
        LOG = LoggerFactory.getLogger(ActorLoader.class);
        ClassLoader.registerAsParallelCapable();
        instance = new ActorLoader("co.paralleluniverse:type=ActorLoader");
        String moduleDirName = System.getProperty(MODULE_DIR_PROPERTY);
        if (moduleDirName != null) {
            Path mdir = Paths.get(moduleDirName, new String[0]);
            try {
                mdir = mdir.toAbsolutePath();
                Files.createDirectories(mdir, new FileAttribute[0]);
                mdir = mdir.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                LOG.error("Error findong/creating module directory " + mdir, (Throwable)e);
                mdir = null;
            }
            moduleDir = mdir;
            ActorLoader.loadModulesInModuleDir(instance, moduleDir);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ActorLoader.monitorFilesystem(instance, moduleDir);
                }
            }, "actor-loader-filesystem-monitor");
            t.setDaemon(true);
            t.start();
        } else {
            moduleDir = null;
        }
    }

    private static class ModuleNotification
    extends Notification {
        static final String NAME = "co.paralleluniverse.actors.module";

        public ModuleNotification(String type, Object source, long sequenceNumber, String message) {
            super(NAME, source, sequenceNumber, message);
        }

        public ModuleNotification(Object source, long sequenceNumber, long timeStamp, String message) {
            super(NAME, source, sequenceNumber, timeStamp, message);
        }
    }
}

