/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorBuilder;
import co.paralleluniverse.actors.ActorLoader;
import co.paralleluniverse.common.reflection.ReflectionUtil;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public class ActorSpec<T extends Actor<Message, V>, Message, V>
implements ActorBuilder<Message, V> {
    private final AtomicReference<Class<T>> classRef;
    private final String className;
    private final Object[] params;
    private Class<?>[] ctorParamTypes;
    private Constructor<T> ctor;

    public static <Message, V, T extends Actor<Message, V>> ActorSpec<T, Message, V> of(Class<T> type, Object ... params) {
        return new ActorSpec<T, Message, V>(type, params);
    }

    public static <Message, V, T extends Actor<Message, V>> ActorSpec<T, Message, V> of(TypeToken<T> type, Object ... params) {
        return new ActorSpec<T, Message, V>(type.getRawType(), params);
    }

    public ActorSpec(String className, Object[] params) {
        this(ActorSpec.matchingConstructor(ActorSpec.currentClassFor(className), params), params, false);
    }

    public ActorSpec(Class<T> type, Object[] params) {
        this(ActorSpec.matchingConstructor(type, params), params, false);
    }

    public ActorSpec(Constructor<T> ctor, Object[] params) {
        this(ctor, params, false);
    }

    private ActorSpec(Constructor<T> ctor, Object[] params, boolean ignore) {
        this.className = ctor.getDeclaringClass().getName();
        this.classRef = ActorLoader.getClassRef(this.className);
        this.params = Arrays.copyOf(params, params.length);
        this.ctor = ctor;
        ctor.setAccessible(true);
    }

    private void updateConstructor() {
        try {
            this.ctor = ActorLoader.currentClassFor(this.ctor.getDeclaringClass()).getConstructor(this.ctor.getParameterTypes());
            this.ctor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static <T> Constructor<T> matchingConstructor(Class<T> type, Object[] params) {
        Constructor ctor = ReflectionUtil.getMatchingConstructor(type, (Class[])ReflectionUtil.getTypes((Object[])params));
        if (ctor == null) {
            throw new IllegalArgumentException("No constructor for type " + type.getName() + " was found to match parameters " + Arrays.toString(params));
        }
        return ctor;
    }

    public T build() {
        if (this.classRef.get() != this.ctor.getDeclaringClass()) {
            this.updateConstructor();
        }
        try {
            Actor instance = (Actor)this.ctor.newInstance(this.params);
            instance.setSpec(this);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String ps = Arrays.toString(this.params);
        return "ActorSpec{" + this.ctor.getName() + "(" + ps.substring(1, ps.length() - 1) + ")}";
    }

    private static Class<?> currentClassFor(String className) {
        try {
            return ActorLoader.currentClassFor(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

