/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.ActorInfo;
import co.paralleluniverse.actors.ActorMonitor;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorsMXBean;
import co.paralleluniverse.actors.LocalActor;
import co.paralleluniverse.common.monitoring.Counter;
import co.paralleluniverse.common.monitoring.MonitoringServices;
import co.paralleluniverse.strands.Strand;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

class JMXActorsMonitor
implements NotificationListener,
ActorsMXBean {
    private static final JMXActorsMonitor instance = new JMXActorsMonitor();
    private final String mbeanName;
    private boolean registered;
    private final Map<Long, ActorRef<?>> actors = new ConcurrentHashMap();
    private final Map<Long, SmallActorMonitor> watchedActors = new ConcurrentHashMap<Long, SmallActorMonitor>();
    private long lastCollectTime;
    private final Counter activeCount = new Counter();

    public static JMXActorsMonitor getInstance() {
        return instance;
    }

    private JMXActorsMonitor() {
        this.mbeanName = "co.paralleluniverse:type=Actors";
        this.registerMBean();
        this.lastCollectTime = this.nanoTime();
    }

    private void registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(this.mbeanName);
            mbs.registerMBean(this, mxbeanName);
            this.registered = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
        MonitoringServices.getInstance().addPerfNotificationListener((NotificationListener)this, (Object)this.mbeanName);
    }

    private void unregister() {
        try {
            if (this.registered) {
                MonitoringServices.getInstance().removePerfNotificationListener((NotificationListener)this);
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.mbeanName));
            }
            this.registered = false;
        }
        catch (InstanceNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("perfTimer".equals(notification.getType())) {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        this.collectAndResetCounters();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    private void collectAndResetCounters() {
        if (this.isRegistered()) {
            this.collectAndResetCounters(this.nanoTime() - this.lastCollectTime);
        }
    }

    protected void collectAndResetCounters(long intervalNanos) {
        this.lastCollectTime = this.nanoTime();
    }

    private long nanoTime() {
        return System.nanoTime();
    }

    void actorStarted(ActorRef<?> actor) {
        this.activeCount.inc();
        this.actors.put(LocalActor.getStrand(actor).getId(), actor);
    }

    void actorTerminated(ActorRef<?> actor, Strand strand) {
        this.activeCount.dec();
        this.actors.remove(strand.getId());
    }

    @Override
    public int getNumActiveActors() {
        return (int)this.activeCount.get();
    }

    @Override
    public long[] getAllActorIds() {
        int size = this.actors.size();
        long[] ids = new long[size];
        int i = 0;
        Iterator<Long> iterator = this.actors.keySet().iterator();
        while (iterator.hasNext()) {
            long id;
            ids[i] = id = iterator.next().longValue();
            ++i;
        }
        if (i < size) {
            return Arrays.copyOf(ids, i);
        }
        return ids;
    }

    @Override
    public String getStackTrace(long actorId) {
        ActorRef<?> actor = this.actors.get(actorId);
        if (actor == null) {
            return null;
        }
        return this.getStackTrace(actor);
    }

    private String getStackTrace(ActorRef actor) {
        StackTraceElement[] stackTrace = LocalActor.getStackTrace(actor);
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : stackTrace) {
            sb.append(ste).append('\n');
        }
        return sb.toString();
    }

    @Override
    public String[] getMailbox(long actorId) {
        ActorRef<?> actor = this.actors.get(actorId);
        if (actor == null) {
            return null;
        }
        return this.getMailbox(actor);
    }

    private String[] getMailbox(ActorRef actor) {
        List<Object> list = LocalActor.getMailboxSnapshot(actor);
        String[] ms = new String[list.size()];
        int i = 0;
        for (Object m : list) {
            ms[i++] = m.toString();
        }
        return ms;
    }

    @Override
    public void addWatch(long actorId) {
        ActorRef<?> actor = this.actors.get(actorId);
        if (actor == null) {
            throw new IllegalArgumentException("No actor with id " + actorId + " found.");
        }
        SmallActorMonitor mon = new SmallActorMonitor(actorId);
        LocalActor.setMonitor(actor, mon);
        this.watchedActors.put(actorId, mon);
    }

    @Override
    public void removeWatch(long actorId) {
        SmallActorMonitor mon = this.watchedActors.get(actorId);
        if (mon == null) {
            return;
        }
        LocalActor.stopMonitor(mon.actor);
    }

    @Override
    public List<ActorInfo> getWatchedActorsInfo() {
        ArrayList<ActorInfo> list = new ArrayList<ActorInfo>(this.watchedActors.size());
        for (SmallActorMonitor mon : this.watchedActors.values()) {
            ActorInfo ai = this.getActorInfo(mon);
            if (ai == null) continue;
            list.add(ai);
        }
        Collections.sort(list, new Comparator<ActorInfo>(){

            @Override
            public int compare(ActorInfo o1, ActorInfo o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        return list;
    }

    private ActorInfo getActorInfo(SmallActorMonitor mon) {
        ActorRef actor = mon.actor;
        if (actor == null) {
            return null;
        }
        return new ActorInfo(mon.id, actor.getName(), LocalActor.getStrand(actor).isFiber(), mon.messages, LocalActor.getQueueLength(actor), (int)mon.restartCounter.get(), mon.deathCauses.toArray(new String[0]), this.getMailbox(actor), this.getStackTrace(actor));
    }

    private class SmallActorMonitor
    implements ActorMonitor {
        private final long id;
        private ActorRef actor;
        private int messageCounter;
        private int skippedMessageCounter;
        private final Counter restartCounter = new Counter();
        private final Queue<String> deathCauses = new ConcurrentLinkedQueue<String>();
        volatile long messages;
        volatile long skippedMessages;

        public SmallActorMonitor(long id) {
            this.id = id;
        }

        void refresh() {
            if (JMXActorsMonitor.this.registered) {
                ActorRef a1 = this.actor;
                if (a1 != null) {
                    this.collect(JMXActorsMonitor.this.nanoTime() - JMXActorsMonitor.this.lastCollectTime);
                }
                this.reset();
            }
        }

        protected void collect(long intervalNanos) {
            this.messages = this.messageCounter;
        }

        protected void reset() {
            this.messageCounter = 0;
            JMXActorsMonitor.this.lastCollectTime = JMXActorsMonitor.this.nanoTime();
        }

        @Override
        public void setActor(ActorRef actor) {
            this.actor = actor;
        }

        @Override
        public void addDeath(Object cause) {
            if (cause == null) {
                cause = "normal";
            }
            while (this.deathCauses.size() > 20) {
                this.deathCauses.poll();
            }
            this.deathCauses.add(cause.toString());
        }

        @Override
        public void addRestart() {
            this.restartCounter.inc();
        }

        @Override
        public void addMessage() {
            ++this.messageCounter;
        }

        @Override
        public void skippedMessage() {
            ++this.skippedMessageCounter;
        }

        @Override
        public void resetSkippedMessages() {
            this.skippedMessageCounter = 0;
        }

        @Override
        public void shutdown() {
            JMXActorsMonitor.this.watchedActors.remove(this.id);
        }
    }
}

