/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors.behaviors;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ExitMessage;
import co.paralleluniverse.actors.LifecycleMessage;
import co.paralleluniverse.actors.MailboxConfig;
import co.paralleluniverse.actors.behaviors.BehaviorActor;
import co.paralleluniverse.actors.behaviors.Initializer;
import co.paralleluniverse.actors.behaviors.Supervisor;
import co.paralleluniverse.actors.behaviors.SupervisorException;
import co.paralleluniverse.concurrent.util.MapUtil;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberFactory;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.StrandFactory;
import co.paralleluniverse.strands.SuspendableCallable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Instrumented
public class SupervisorActor
extends BehaviorActor {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorActor.class);
    private final RestartStrategy restartStrategy;
    private List<Supervisor.ChildSpec> childSpec;
    private final List<ChildEntry> children = new ArrayList<ChildEntry>();
    private final ConcurrentMap<Object, ChildEntry> childrenById = MapUtil.newConcurrentHashMap();

    public SupervisorActor(Strand strand, String name, MailboxConfig mailboxConfig, RestartStrategy restartStrategy, Initializer initializer) {
        super(name, initializer, strand, mailboxConfig);
        this.restartStrategy = restartStrategy;
        this.childSpec = null;
    }

    public SupervisorActor(Strand strand, String name, MailboxConfig mailboxConfig, RestartStrategy restartStrategy, List<Supervisor.ChildSpec> childSpec) {
        super(name, null, strand, mailboxConfig);
        this.restartStrategy = restartStrategy;
        this.childSpec = childSpec;
    }

    public SupervisorActor(Strand strand, String name, MailboxConfig mailboxConfig, RestartStrategy restartStrategy, Supervisor.ChildSpec ... childSpec) {
        this(strand, name, mailboxConfig, restartStrategy, Arrays.asList(childSpec));
    }

    @Override
    protected Supervisor makeRef(ActorRef<Object> ref) {
        return new Supervisor(ref);
    }

    @Override
    public Supervisor ref() {
        return (Supervisor)super.ref();
    }

    @Override
    protected Supervisor self() {
        return this.ref();
    }

    @Override
    public Supervisor spawn(StrandFactory sf) {
        return (Supervisor)super.spawn(sf);
    }

    @Override
    public Supervisor spawn(FiberFactory ff) {
        return (Supervisor)super.spawn(ff);
    }

    @Override
    public Supervisor spawn() {
        return (Supervisor)super.spawn();
    }

    @Override
    public Supervisor spawnThread() {
        return (Supervisor)super.spawnThread();
    }

    public static SupervisorActor currentSupervisor() {
        return (SupervisorActor)Actor.currentActor();
    }

    @Override
    public Logger log() {
        return LOG;
    }

    public SupervisorActor(Strand strand, String name, MailboxConfig mailboxConfig, RestartStrategy restartStrategy) {
        this(strand, name, mailboxConfig, restartStrategy, (Initializer)null);
    }

    public SupervisorActor(String name, MailboxConfig mailboxConfig, RestartStrategy restartStrategy) {
        this(null, name, mailboxConfig, restartStrategy, (Initializer)null);
    }

    public SupervisorActor(String name, RestartStrategy restartStrategy) {
        this(null, name, null, restartStrategy, (Initializer)null);
    }

    public SupervisorActor(String name, MailboxConfig mailboxConfig, RestartStrategy restartStrategy, Initializer initializer) {
        this(null, name, mailboxConfig, restartStrategy, initializer);
    }

    public SupervisorActor(String name, RestartStrategy restartStrategy, Initializer initializer) {
        this(null, name, null, restartStrategy, initializer);
    }

    public SupervisorActor(RestartStrategy restartStrategy) {
        this(null, null, null, restartStrategy, (Initializer)null);
    }

    public SupervisorActor(String name, MailboxConfig mailboxConfig, RestartStrategy restartStrategy, List<Supervisor.ChildSpec> childSpec) {
        this(null, name, mailboxConfig, restartStrategy, childSpec);
    }

    public SupervisorActor(String name, MailboxConfig mailboxConfig, RestartStrategy restartStrategy, Supervisor.ChildSpec ... childSpec) {
        this(null, name, mailboxConfig, restartStrategy, childSpec);
    }

    public SupervisorActor(String name, RestartStrategy restartStrategy, List<Supervisor.ChildSpec> childSpec) {
        this(null, name, null, restartStrategy, childSpec);
    }

    public SupervisorActor(String name, RestartStrategy restartStrategy, Supervisor.ChildSpec ... childSpec) {
        this(null, name, null, restartStrategy, childSpec);
    }

    public SupervisorActor(RestartStrategy restartStrategy, List<Supervisor.ChildSpec> childSpec) {
        this(null, null, null, restartStrategy, childSpec);
    }

    public SupervisorActor(RestartStrategy restartStrategy, Supervisor.ChildSpec ... childSpec) {
        this(null, null, null, restartStrategy, childSpec);
    }

    private ChildEntry addChild1(Supervisor.ChildSpec spec) {
        this.log().debug("Adding child {}", (Object)spec);
        ActorRef actor = null;
        if (spec.builder instanceof ActorRef && this.findEntry(actor = (ActorRef)((Object)spec.builder)) != null) {
            throw new SupervisorException("Supervisor " + this + " already supervises actor " + actor);
        }
        String id = spec.getId();
        if (id == null && actor != null) {
            id = actor.getName();
        }
        if (id != null && this.findEntryById(id) != null) {
            throw new SupervisorException("Supervisor " + this + " already supervises an actor by the name " + id);
        }
        ChildEntry child = new ChildEntry(spec, actor);
        this.children.add(child);
        if (id != null) {
            this.childrenById.put(id, child);
        }
        return child;
    }

    protected <T extends ActorRef<M>, M> T getChild(Object id) {
        this.verifyInActor();
        ChildEntry child = this.findEntryById(id);
        if (child == null) {
            return null;
        }
        return (T)child.actor;
    }

    protected List<? extends ActorRef<?>> getChildren() {
        this.verifyInActor();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ChildEntry ce : this.children) {
            builder.add(ce.actor);
        }
        return builder.build();
    }

    private void removeChild(ChildEntry child, Iterator<ChildEntry> iter) {
        if (child.spec.getId() != null) {
            this.childrenById.remove(child.spec.getId());
        }
        if (iter != null) {
            iter.remove();
        } else {
            this.children.remove(child);
        }
    }

    @Override
    protected final Object handleLifecycleMessage(LifecycleMessage m) {
        ExitMessage death;
        if (m instanceof ExitMessage && (death = (ExitMessage)m).getWatch() != null) {
            return death;
        }
        super.handleLifecycleMessage(m);
        return null;
    }

    private ActorRef start(ChildEntry child, ActorRef actor) {
        child.actor = actor;
        child.watch = this.watch(actor);
        return actor;
    }

    private void unwatch(ChildEntry child) {
        if (child.actor != null && child.watch != null) {
            this.unwatch(child.actor, child.watch);
            child.watch = null;
        }
    }

    private Strand createStrandForActor(Strand oldStrand, Actor actor) {
        Object strand = oldStrand != null ? Strand.clone((Strand)oldStrand, (SuspendableCallable)actor) : new Fiber((SuspendableCallable)actor);
        actor.setStrand((Strand)strand);
        return strand;
    }

    private ChildEntry findEntry(ActorRef actor) {
        ChildEntry child;
        if (actor.getName() != null && (child = this.findEntryById(actor.getName())) != null) {
            return child;
        }
        for (ChildEntry child2 : this.children) {
            if (!Objects.equals(child2.actor, actor)) continue;
            return child2;
        }
        return null;
    }

    private ChildEntry findEntryById(Object name) {
        return (ChildEntry)this.childrenById.get(name);
    }

    private long now() {
        return System.nanoTime() / 1000000L;
    }

    static /* synthetic */ long access$100(SupervisorActor x0) {
        return x0.now();
    }

    static /* synthetic */ List access$400(SupervisorActor x0) {
        return x0.children;
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=299, methodEnd=317, suspendableCallSites={300, 310}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/Initializer.init()V", "co/paralleluniverse/actors/behaviors/SupervisorActor.addChild(Lco/paralleluniverse/actors/behaviors/Supervisor$ChildSpec;)Lco/paralleluniverse/actors/ActorRef;"}, suspendableCallSitesOffsetsAfterInstr={89, 243})
    protected void init() throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=321, methodEnd=326, suspendableCallSites={325}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/BehaviorActor.onStart()V"}, suspendableCallSitesOffsetsAfterInstr={94})
    protected void onStart() throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=330, methodEnd=359, suspendableCallSites={334, 336, 338, 338, 341, 341, 341, 344, 352, 353}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.removeChild(Ljava/lang/Object;Z)Z", "co/paralleluniverse/actors/behaviors/SupervisorActor$RestartStrategy.onChildDeath(Lco/paralleluniverse/actors/behaviors/SupervisorActor;Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Ljava/lang/Throwable;)Z", "co/paralleluniverse/actors/behaviors/RequestReplyHelper.reply(Lco/paralleluniverse/actors/behaviors/RequestMessage;Ljava/lang/Object;)V", "-.makeConcatWithConstants(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;)Ljava/lang/String;", "co/paralleluniverse/actors/behaviors/RequestReplyHelper.replyError(Lco/paralleluniverse/actors/behaviors/RequestMessage;Ljava/lang/Throwable;)V", "co/paralleluniverse/actors/behaviors/SupervisorActor.removeChild(Lco/paralleluniverse/actors/ActorRef;Z)Z", "co/paralleluniverse/actors/behaviors/SupervisorActor.addChild(Lco/paralleluniverse/actors/behaviors/Supervisor$ChildSpec;)Lco/paralleluniverse/actors/ActorRef;"}, suspendableCallSitesOffsetsAfterInstr={197, 291, 404, 483, 645, 779, 879, 982, 1137, 1310})
    protected final void handleMessage(Object var1_1) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(methodOptimized=false, methodStart=363, methodEnd=373, suspendableCallSites={363, 365}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.shutdownChildren()V", "co/paralleluniverse/actors/behaviors/BehaviorActor.onTerminate(Ljava/lang/Throwable;)V"}, suspendableCallSitesOffsetsAfterInstr={106, 150})
    protected void onTerminate(Throwable var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=404, methodEnd=417, suspendableCallSites={413}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.start(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;)Lco/paralleluniverse/actors/ActorRef;"}, suspendableCallSitesOffsetsAfterInstr={209})
    protected final <T extends ActorRef<M>, M> T addChild(Supervisor.ChildSpec var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=456, methodEnd=472, suspendableCallSites={468}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.shutdownChild(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Z)V"}, suspendableCallSitesOffsetsAfterInstr={226})
    protected final boolean removeChild(Object var1_1, boolean var2_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=484, methodEnd=500, suspendableCallSites={496}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.shutdownChild(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Z)V"}, suspendableCallSitesOffsetsAfterInstr={229})
    protected final boolean removeChild(ActorRef var1_1, boolean var2_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=524, methodEnd=552, suspendableCallSites={535, 541, 544, 548}, suspendableCallSiteNames={"-.makeConcatWithConstants(Lco/paralleluniverse/actors/behaviors/SupervisorActor;)Ljava/lang/String;", "co/paralleluniverse/actors/behaviors/SupervisorActor.shutdownChild(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Z)V", "co/paralleluniverse/actors/behaviors/SupervisorActor.start(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;)Lco/paralleluniverse/actors/ActorRef;"}, suspendableCallSitesOffsetsAfterInstr={324, 606, 798, 964})
    private boolean tryRestart(ChildEntry var1_1, Throwable var2_2, long var3_3, Iterator<ChildEntry> var5_4, boolean var6_5) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=557, methodEnd=584, suspendableCallSites={559, 561}, suspendableCallSiteNames={"co/paralleluniverse/actors/ActorBuilder.build()Lco/paralleluniverse/actors/Actor;", "-.makeConcatWithConstants(Lco/paralleluniverse/actors/ActorRef;)Ljava/lang/String;"}, suspendableCallSitesOffsetsAfterInstr={142, 230})
    private ActorRef<?> start(ChildEntry var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=595, methodEnd=613, suspendableCallSites={604}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.joinChild(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;)Z"}, suspendableCallSitesOffsetsAfterInstr={208})
    private void shutdownChild(ChildEntry var1_1, boolean var2_2) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=616, methodEnd=635, suspendableCallSites={627}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.joinChild(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;)Z"}, suspendableCallSitesOffsetsAfterInstr={255})
    private void shutdownChildren() throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(methodOptimized=false, methodStart=638, methodEnd=671, suspendableCallSites={643, 655}, suspendableCallSiteNames={"co/paralleluniverse/actors/LocalActor.join(Lco/paralleluniverse/actors/ActorRef;JLjava/util/concurrent/TimeUnit;)V"}, suspendableCallSitesOffsetsAfterInstr={184, 390})
    private boolean joinChild(ChildEntry var1_1) throws SuspendExecution, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented(methodOptimized=true, methodStart=65, methodEnd=65, suspendableCallSites={65}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.tryRestart(Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Ljava/lang/Throwable;JLjava/util/Iterator;Z)Z"}, suspendableCallSitesOffsetsAfterInstr={8})
    static /* synthetic */ boolean access$200(SupervisorActor x0, ChildEntry x1, Throwable x2, long x3, Iterator x4, boolean x5) throws SuspendExecution, InterruptedException {
        return x0.tryRestart(x1, x2, x3, x4, x5);
    }

    @Instrumented(methodOptimized=true, methodStart=65, methodEnd=65, suspendableCallSites={65}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.shutdownChildren()V"}, suspendableCallSitesOffsetsAfterInstr={1})
    static /* synthetic */ void access$300(SupervisorActor x0) throws SuspendExecution, InterruptedException {
        x0.shutdownChildren();
    }

    private static class RestartHistory {
        private final long[] restarts;
        private int index;

        public RestartHistory(int windowSize) {
            this.restarts = new long[windowSize];
            this.index = 0;
        }

        public void addRestart(long now) {
            this.restarts[this.index] = now;
            this.index = this.mod(this.index + 1);
        }

        public int numRestarts(long since) {
            int count = 0;
            int i = this.mod(this.index - 1);
            while (i != this.index && this.restarts[i] >= since) {
                ++count;
                i = this.mod(i - 1);
            }
            if (this.restarts[this.index] >= since) {
                ++count;
            }
            return count;
        }

        private int mod(int i) {
            if (i >= this.restarts.length) {
                return i - this.restarts.length;
            }
            if (i < 0) {
                return i + this.restarts.length;
            }
            return i;
        }
    }

    private static class ChildEntry {
        final Supervisor.ChildSpec spec;
        final RestartHistory restartHistory;
        Object watch;
        volatile ActorRef<?> actor;

        public ChildEntry(Supervisor.ChildSpec info) {
            this(info, null);
        }

        public ChildEntry(Supervisor.ChildSpec info, ActorRef<?> actor) {
            this.spec = info;
            this.restartHistory = new RestartHistory(info.maxRestarts + 1);
            this.actor = actor;
        }

        public String toString() {
            return "ActorEntry{info=" + this.spec + " actor=" + this.actor + "}";
        }
    }

    public static enum RestartStrategy {
        ESCALATE{

            /*
             * Exception decompiling
             */
            @Override
            @Instrumented(methodOptimized=false, methodStart=724, methodEnd=731, suspendableCallSites={725, 725, 729, 729}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.access$100(Lco/paralleluniverse/actors/behaviors/SupervisorActor;)J", "co/paralleluniverse/actors/behaviors/SupervisorActor.access$200(Lco/paralleluniverse/actors/behaviors/SupervisorActor;Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Ljava/lang/Throwable;JLjava/util/Iterator;Z)Z"}, suspendableCallSitesOffsetsAfterInstr={212, 355, 523, 666})
            boolean onChildDeath(SupervisorActor var1_1, ChildEntry var2_2, Throwable var3_3) throws SuspendExecution, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
        ,
        ONE_FOR_ONE{

            /*
             * Exception decompiling
             */
            @Override
            @Instrumented(methodOptimized=false, methodStart=741, methodEnd=741, suspendableCallSites={741, 741}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.access$100(Lco/paralleluniverse/actors/behaviors/SupervisorActor;)J", "co/paralleluniverse/actors/behaviors/SupervisorActor.access$200(Lco/paralleluniverse/actors/behaviors/SupervisorActor;Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Ljava/lang/Throwable;JLjava/util/Iterator;Z)Z"}, suspendableCallSitesOffsetsAfterInstr={191, 334})
            boolean onChildDeath(SupervisorActor var1_1, ChildEntry var2_2, Throwable var3_3) throws InterruptedException, SuspendExecution {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
        ,
        ALL_FOR_ONE{

            /*
             * Exception decompiling
             */
            @Override
            @Instrumented(methodOptimized=false, methodStart=750, methodEnd=762, suspendableCallSites={752, 752, 755, 756, 758, 758}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.access$100(Lco/paralleluniverse/actors/behaviors/SupervisorActor;)J", "co/paralleluniverse/actors/behaviors/SupervisorActor.access$300(Lco/paralleluniverse/actors/behaviors/SupervisorActor;)V", "co/paralleluniverse/actors/behaviors/SupervisorActor.access$400(Lco/paralleluniverse/actors/behaviors/SupervisorActor;)Ljava/util/List;", "co/paralleluniverse/actors/behaviors/SupervisorActor.access$200(Lco/paralleluniverse/actors/behaviors/SupervisorActor;Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Ljava/lang/Throwable;JLjava/util/Iterator;Z)Z"}, suspendableCallSitesOffsetsAfterInstr={237, 380, 482, 567, 785, 997})
            boolean onChildDeath(SupervisorActor var1_1, ChildEntry var2_2, Throwable var3_3) throws SuspendExecution, InterruptedException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
        ,
        REST_FOR_ONE{

            /*
             * Exception decompiling
             */
            @Override
            @Instrumented(methodOptimized=false, methodStart=772, methodEnd=787, suspendableCallSites={774, 774, 778, 783, 783}, suspendableCallSiteNames={"co/paralleluniverse/actors/behaviors/SupervisorActor.access$100(Lco/paralleluniverse/actors/behaviors/SupervisorActor;)J", "co/paralleluniverse/actors/behaviors/SupervisorActor.access$400(Lco/paralleluniverse/actors/behaviors/SupervisorActor;)Ljava/util/List;", "co/paralleluniverse/actors/behaviors/SupervisorActor.access$200(Lco/paralleluniverse/actors/behaviors/SupervisorActor;Lco/paralleluniverse/actors/behaviors/SupervisorActor$ChildEntry;Ljava/lang/Throwable;JLjava/util/Iterator;Z)Z"}, suspendableCallSitesOffsetsAfterInstr={233, 376, 497, 745, 972})
            boolean onChildDeath(SupervisorActor var1_1, ChildEntry var2_2, Throwable var3_3) throws InterruptedException, SuspendExecution {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };


        abstract boolean onChildDeath(SupervisorActor var1, ChildEntry var2, Throwable var3) throws SuspendExecution, InterruptedException;
    }
}

