/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors.spi;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.common.reflection.ReflectionUtil;
import co.paralleluniverse.fibers.SuspendExecution;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public abstract class ActorRegistry {
    private static final Method getGlobalId;
    private static final Method setGlobalId;

    public abstract <Message> void register(Actor<Message, ?> var1, ActorRef<Message> var2) throws SuspendExecution;

    public abstract <Message> void unregister(Actor<Message, ?> var1, ActorRef<Message> var2);

    public abstract ActorRef<?> getActor(String var1) throws InterruptedException, SuspendExecution;

    public abstract ActorRef<?> getActor(String var1, long var2, TimeUnit var4) throws InterruptedException, SuspendExecution;

    public abstract ActorRef<?> tryGetActor(String var1) throws SuspendExecution;

    public abstract <T extends ActorRef<?>> T getOrRegisterActor(String var1, Callable<T> var2) throws SuspendExecution;

    public abstract void shutdown();

    protected Object getGlobalId(Actor<?, ?> actor) {
        try {
            return getGlobalId.invoke(actor, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void setGlobalId(Actor<?, ?> actor, Object globalId) {
        try {
            setGlobalId.invoke(actor, globalId);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try {
            getGlobalId = (Method)ReflectionUtil.accessible((AccessibleObject)Actor.class.getDeclaredMethod("getGlobalId", new Class[0]));
            setGlobalId = (Method)ReflectionUtil.accessible((AccessibleObject)Actor.class.getDeclaredMethod("setGlobalId", Object.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

