/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.io.serialization.Serialization;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;

class ThreadLocalSerializer
extends Serializer<ThreadLocal<?>> {
    public ThreadLocalSerializer() {
        this.setImmutable(true);
    }

    public void write(Kryo kryo, Output output, ThreadLocal<?> tl) {
        output.writeBoolean(tl instanceof InheritableThreadLocal);
        Object val = tl.get();
        boolean reset = ThreadLocalSerializer.shouldReset(kryo, tl, val);
        kryo.writeObject(output, (Object)new ThreadLocalValue(val, reset));
    }

    public ThreadLocal<?> read(Kryo kryo, Input input, Class<ThreadLocal<?>> type) {
        ThreadLocal tl;
        boolean itl = input.readBoolean();
        ThreadLocalValue tlv = (ThreadLocalValue)kryo.readObject(input, ThreadLocalValue.class);
        ThreadLocal threadLocal = tl = itl ? new InheritableThreadLocal() : new ThreadLocal();
        if (!tlv.reset) {
            tl.set(tlv.val);
        }
        return tl;
    }

    private static boolean shouldReset(Kryo kryo, ThreadLocal<?> tl, Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Serializable || kryo.getClassResolver().getRegistration(val.getClass()) != null) {
            return false;
        }
        if (val instanceof Serialization) {
            return true;
        }
        if (!kryo.getDefaultSerializer(val.getClass()).getClass().isAssignableFrom(FieldSerializer.class)) {
            return false;
        }
        System.err.println("WARNING: cannot serialize ThreadLocal (" + tl + " = " + val + ")");
        return true;
    }

    static class ThreadLocalValue
    implements Serializable {
        boolean reset;
        Object val;

        public ThreadLocalValue(Object val, boolean reset) {
            this.val = reset ? null : val;
            this.reset = reset;
        }
    }
}

