/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.AnnotationVisitor;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.fibers.instrument.Classes;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SuspendableClassifier;
import co.paralleluniverse.fibers.instrument.UnableToInstrumentException;

public class CheckInstrumentationVisitor
extends ClassVisitor {
    private final MethodDatabase db;
    private final SuspendableClassifier classifier;
    private String sourceName;
    private String sourceDebugInfo;
    private boolean isInterface;
    private String className;
    private boolean suspendableInterface;
    private MethodDatabase.ClassEntry classEntry;
    private boolean hasSuspendable;
    private boolean alreadyInstrumented;

    public CheckInstrumentationVisitor(MethodDatabase db) {
        super(327680);
        this.db = db;
        this.classifier = db.getClassifier();
    }

    public boolean needsInstrumentation() {
        return this.hasSuspendable;
    }

    MethodDatabase.ClassEntry getClassEntry() {
        return this.classEntry;
    }

    public String getName() {
        return this.className;
    }

    public boolean isAlreadyInstrumented() {
        return this.alreadyInstrumented;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.isInterface = (access & 0x200) != 0;
        this.classEntry = new MethodDatabase.ClassEntry(superName);
        this.classEntry.setInterfaces(interfaces);
        this.classEntry.setIsInterface(this.isInterface);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.sourceName = source;
        this.sourceDebugInfo = debug;
        super.visitSource(source, debug);
        this.classEntry.setSourceName(this.sourceName);
        this.classEntry.setSourceDebugInfo(this.sourceDebugInfo);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals(Classes.ALREADY_INSTRUMENTED_DESC)) {
            this.alreadyInstrumented = true;
        } else if (this.isInterface && desc.equals("Lco/paralleluniverse/fibers/Suspendable;")) {
            this.suspendableInterface = true;
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodDatabase.SuspendableType suspendable = null;
        if (this.suspendableInterface) {
            suspendable = MethodDatabase.SuspendableType.SUSPENDABLE_SUPER;
        }
        if (suspendable == null) {
            suspendable = this.classEntry.check(name, desc);
        }
        if (suspendable == null) {
            suspendable = this.classifier.isSuspendable(this.db, this.sourceName, this.sourceDebugInfo, this.isInterface, this.className, this.classEntry.getSuperName(), this.classEntry.getInterfaces(), name, desc, signature, exceptions);
        }
        if (suspendable == MethodDatabase.SuspendableType.SUSPENDABLE) {
            this.hasSuspendable = true;
            if ((access & 0x20) == 32 && !this.className.equals("clojure/lang/LazySeq")) {
                throw new UnableToInstrumentException("synchronized method", this.className, name, desc);
            }
        }
        this.classEntry.set(name, desc, suspendable);
        if (suspendable == null) {
            return new MethodVisitor(327680){
                private boolean susp;
                {
                    super(x0);
                    this.susp = false;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String adesc, boolean visible) {
                    if (adesc.equals("Lco/paralleluniverse/fibers/Suspendable;")) {
                        this.susp = true;
                    }
                    return null;
                }

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    CheckInstrumentationVisitor.this.classEntry.set(name, desc, this.susp ? MethodDatabase.SuspendableType.SUSPENDABLE : MethodDatabase.SuspendableType.NON_SUSPENDABLE);
                    CheckInstrumentationVisitor.this.hasSuspendable = CheckInstrumentationVisitor.this.hasSuspendable | this.susp;
                }
            };
        }
        return null;
    }
}

