/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.ClassReader;
import co.paralleluniverse.asm.util.Textifier;
import co.paralleluniverse.asm.util.TraceClassVisitor;
import co.paralleluniverse.concurrent.util.MapUtil;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import co.paralleluniverse.fibers.instrument.SuspendableHelper;
import java.io.PrintWriter;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class Retransform {
    static volatile Instrumentation instrumentation;
    static volatile MethodDatabase db;
    static volatile Set<WeakReference<ClassLoader>> classLoaders;
    private static final CopyOnWriteArrayList<ClassLoadListener> listeners;

    public static void retransform(Class<?> clazz) throws UnmodifiableClassException {
        instrumentation.retransformClasses(clazz);
    }

    public static void redefine(Collection<ClassDefinition> classDefinitions) {
        try {
            instrumentation.redefineClasses(classDefinitions.toArray(new ClassDefinition[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodDatabase getMethodDB() {
        return db;
    }

    public static boolean isInstrumented(Class clazz) {
        return SuspendableHelper.isInstrumented(clazz);
    }

    public static void addWaiver(String className, String methodName) {
        SuspendableHelper.addWaiver(className, methodName);
    }

    public static boolean isWaiver(String className, String methodName) {
        return SuspendableHelper.isWaiver(className, methodName);
    }

    public static Boolean isSuspendable(String className, String methodName) {
        if (db == null) {
            return null;
        }
        MethodDatabase.ClassEntry ce = db.getClassEntry(className);
        if (ce == null) {
            return null;
        }
        return ce.isSuspendable(methodName);
    }

    static void beforeTransform(String className, Class clazz, byte[] data) {
        for (ClassLoadListener listener : listeners) {
            listener.beforeTransform(className, clazz, data);
        }
    }

    static void afterTransform(String className, Class clazz, byte[] data) {
        for (ClassLoadListener listener : listeners) {
            listener.afterTransform(className, clazz, data);
        }
    }

    public static void dumpClass(String className, byte[] data) {
        System.out.println("DUMP OF CLASS: " + className);
        ClassReader cr = new ClassReader(data);
        TraceClassVisitor cv = new TraceClassVisitor(null, new Textifier(), new PrintWriter(System.out));
        cr.accept(cv, 4);
        System.out.println("=================");
    }

    public static void addClassLoadListener(ClassLoadListener listener) {
        listeners.addIfAbsent(listener);
    }

    static {
        classLoaders = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
        listeners = new CopyOnWriteArrayList();
    }

    public static interface ClassLoadListener {
        public void beforeTransform(String var1, Class var2, byte[] var3);

        public void afterTransform(String var1, Class var2, byte[] var3);
    }
}

