/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands;

import co.paralleluniverse.strands.Condition;
import co.paralleluniverse.strands.ConditionSynchronizer;
import co.paralleluniverse.strands.Strand;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SimpleConditionSynchronizer
extends ConditionSynchronizer
implements Condition {
    private final Queue<Strand> waiters = new ConcurrentLinkedQueue<Strand>();

    public SimpleConditionSynchronizer(Object owner) {
        super(owner);
    }

    @Override
    public Object register() {
        Strand currentStrand = Strand.currentStrand();
        SimpleConditionSynchronizer.record("register", "%s register %s", this, currentStrand);
        this.waiters.add(currentStrand);
        return null;
    }

    @Override
    public void unregister(Object registrationToken) {
        Strand currentStrand = Strand.currentStrand();
        SimpleConditionSynchronizer.record("unregister", "%s unregister %s", this, currentStrand);
        if (!this.waiters.remove(currentStrand)) {
            throw new IllegalMonitorStateException();
        }
    }

    @Override
    public void signalAll() {
        for (Strand s : this.waiters) {
            SimpleConditionSynchronizer.record("signalAll", "%s signalling %s", this, s);
            Strand.unpark(s, this.owner);
        }
    }

    @Override
    public void signal() {
        Strand s = this.waiters.peek();
        if (s != null) {
            SimpleConditionSynchronizer.record("signal", "%s signalling %s", this, s);
            Strand.unpark(s, this.owner);
        }
    }
}

