/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.strands.queues.BasicQueue;
import sun.misc.Unsafe;

public abstract class CircularBuffer<E>
implements BasicQueue<E> {
    final int capacity;
    final int mask;
    private final boolean singleProducer;
    volatile long p101;
    volatile long p102;
    volatile long p103;
    volatile long p104;
    volatile long p105;
    volatile long p106;
    volatile long p107;
    volatile long tail;
    volatile long p201;
    volatile long p202;
    volatile long p203;
    volatile long p204;
    volatile long p205;
    volatile long p206;
    volatile long p207;
    volatile long lastWritten;
    volatile Object p301;
    volatile Object p302;
    volatile Object p303;
    volatile Object p304;
    volatile Object p305;
    volatile Object p306;
    volatile Object p307;
    final Consumer consumer;
    static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long tailOffset;
    private static final long lastWrittenOffset;

    CircularBuffer(int capacity, boolean singleProducer) {
        this.capacity = CircularBuffer.nextPowerOfTwo(capacity);
        this.mask = this.capacity - 1;
        this.singleProducer = singleProducer;
        this.consumer = this.newConsumer();
    }

    public boolean isSingleProducer() {
        return this.singleProducer;
    }

    public Consumer builtinConsumer() {
        return this.consumer;
    }

    private static int nextPowerOfTwo(int v) {
        assert (v >= 0);
        return 1 << 32 - Integer.numberOfLeadingZeros(v - 1);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    final long preEnq() {
        long t;
        if (this.singleProducer) {
            t = this.tail++;
        } else {
            while (!this.casTail(t = this.tail, t + 1L)) {
            }
        }
        return t;
    }

    final void postEnq() {
        if (this.singleProducer) {
            ++this.lastWritten;
        } else {
            long w;
            while (!this.casLastWritten(w = this.lastWritten, w + 1L)) {
            }
        }
    }

    @Override
    public abstract boolean enq(E var1);

    @Override
    public E poll() {
        return this.consumer.poll();
    }

    @Override
    public int size() {
        return this.consumer.size();
    }

    public boolean hasNext() {
        return this.consumer.hasNext();
    }

    public abstract Consumer newConsumer();

    private void orderedSetTail(long value) {
        UNSAFE.putOrderedLong(this, tailOffset, value);
    }

    boolean casTail(long expected, long update) {
        return UNSAFE.compareAndSwapLong(this, tailOffset, expected, update);
    }

    boolean casLastWritten(long expected, long update) {
        return UNSAFE.compareAndSwapLong(this, lastWrittenOffset, expected, update);
    }

    static {
        try {
            tailOffset = UNSAFE.objectFieldOffset(CircularBuffer.class.getDeclaredField("tail"));
            lastWrittenOffset = UNSAFE.objectFieldOffset(CircularBuffer.class.getDeclaredField("lastWritten"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    public abstract class Consumer {
        long head;

        public final long lastIndexRead() {
            return this.head - 1L;
        }

        public final boolean hasNext() {
            return CircularBuffer.this.tail > this.head;
        }

        public void poll0() {
            assert (CircularBuffer.this.tail > this.head);
            int headStart = 0;
            int attempt = 0;
            while (true) {
                if (CircularBuffer.this.lastWritten <= this.head) {
                    continue;
                }
                this.grabValue((int)this.head & CircularBuffer.this.mask);
                long oldest = CircularBuffer.this.tail - (long)CircularBuffer.this.capacity;
                if (this.head >= oldest) {
                    ++this.head;
                    return;
                }
                this.head = oldest + (long)headStart;
                if (attempt > 30) {
                    throw new RuntimeException("Can't catch up with producer");
                }
                ++attempt;
            }
        }

        public E poll() {
            if (!this.hasNext()) {
                return null;
            }
            this.poll0();
            Object v = this.getValue();
            this.clearValue();
            return v;
        }

        public E getAndClearReadValue() {
            Object v = this.getValue();
            this.clearValue();
            return v;
        }

        public int size() {
            return (int)(CircularBuffer.this.tail - this.head);
        }

        protected abstract void grabValue(int var1);

        protected abstract void clearValue();

        protected abstract E getValue();
    }
}

