/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.BasicSingleConsumerFloatQueue;
import co.paralleluniverse.strands.queues.FloatQueueIterator;
import co.paralleluniverse.strands.queues.SingleConsumerArrayQueue;
import co.paralleluniverse.strands.queues.SingleConsumerArrayWordQueue;

public class SingleConsumerArrayFloatQueue
extends SingleConsumerArrayWordQueue<Float>
implements BasicSingleConsumerFloatQueue {
    public SingleConsumerArrayFloatQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean enq(float item) {
        return this.enqRaw(Float.floatToRawIntBits(item));
    }

    @Override
    public boolean enq(Float item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        return this.enq(item.floatValue());
    }

    float floatValue(int index) {
        return Float.intBitsToFloat(this.rawValue(index));
    }

    @Override
    Float value(int index) {
        return Float.valueOf(this.floatValue(index));
    }

    @Override
    public float pollFloat() {
        int n = this.pk();
        float val = this.floatValue(n);
        this.deq(n);
        return val;
    }

    @Override
    public FloatQueueIterator iterator() {
        return new FloatArrayQueueIterator();
    }

    private class FloatArrayQueueIterator
    extends SingleConsumerArrayQueue.ArrayQueueIterator
    implements FloatQueueIterator {
        private FloatArrayQueueIterator() {
            super(SingleConsumerArrayFloatQueue.this);
        }

        @Override
        public float floatValue() {
            return SingleConsumerArrayFloatQueue.this.floatValue(this.n);
        }

        @Override
        public float floatNext() {
            this.n = SingleConsumerArrayFloatQueue.this.succ(this.n);
            return this.floatValue();
        }
    }
}

