/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedArrayQueue;
import java.util.Arrays;

public class SingleConsumerLinkedArrayObjectQueue<E>
extends SingleConsumerLinkedArrayQueue<E> {
    public static final int BLOCK_SIZE = 10;
    private static final Object TOMBSTONE = new Object();
    private static final int base;
    private static final int shift;

    @Override
    SingleConsumerLinkedArrayQueue.Node newNode() {
        return new ObjectNode();
    }

    @Override
    int blockSize() {
        return 10;
    }

    @Override
    public boolean enq(E item) {
        while (true) {
            SingleConsumerLinkedArrayQueue.Node t = this.tail;
            for (int i = 0; i < 10; ++i) {
                if (SingleConsumerLinkedArrayObjectQueue.get(t, i) != null) continue;
                if (SingleConsumerLinkedArrayObjectQueue.compareAndSetElement(t, i, null, item)) {
                    return true;
                }
                this.backoff();
            }
            SingleConsumerLinkedArrayQueue.Node n = this.newNode();
            n.prev = t;
            if (this.compareAndSetTail(t, n)) {
                t.next = n;
                continue;
            }
            this.backoff();
        }
    }

    @Override
    E value(SingleConsumerLinkedArrayQueue.Node n, int i) {
        return (E)((ObjectNode)n).array[i];
    }

    @Override
    boolean hasValue(SingleConsumerLinkedArrayQueue.Node n, int index) {
        return SingleConsumerLinkedArrayObjectQueue.get(n, index) != null;
    }

    @Override
    boolean isDeleted(SingleConsumerLinkedArrayQueue.Node n, int index) {
        return ((ObjectNode)n).array[index] == TOMBSTONE;
    }

    @Override
    void markDeleted(SingleConsumerLinkedArrayQueue.Node n, int index) {
        ((ObjectNode)n).array[index] = TOMBSTONE;
    }

    private static boolean compareAndSetElement(SingleConsumerLinkedArrayQueue.Node n, int i, Object expect, Object update) {
        return UNSAFE.compareAndSwapObject(((ObjectNode)n).array, SingleConsumerLinkedArrayObjectQueue.byteOffset(i), expect, update);
    }

    private static void lazySet(SingleConsumerLinkedArrayQueue.Node n, int i, Object value) {
        UNSAFE.putOrderedObject(((ObjectNode)n).array, SingleConsumerLinkedArrayObjectQueue.byteOffset(i), value);
    }

    private static Object get(SingleConsumerLinkedArrayQueue.Node n, int i) {
        return UNSAFE.getObjectVolatile(((ObjectNode)n).array, SingleConsumerLinkedArrayObjectQueue.byteOffset(i));
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    static {
        try {
            base = UNSAFE.arrayBaseOffset(Object[].class);
            int scale = UNSAFE.arrayIndexScale(Object[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    static class ObjectNode
    extends SingleConsumerLinkedArrayQueue.Node {
        final Object[] array = new Object[10];

        ObjectNode() {
        }

        public String toString() {
            return "Node{array: " + Arrays.toString(this.array) + ", next: " + this.next + ", prev: " + Objects.systemToString(this.prev) + '}';
        }
    }
}

