/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ExecutorServiceLatencyProbe {
    private final ExecutorService executor;
    private final int numProbes;

    public ExecutorServiceLatencyProbe(ExecutorService executor, int numProbes) {
        this.executor = executor;
        this.numProbes = numProbes;
    }

    public long[] fire() {
        Callable<Long> task = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return System.nanoTime();
            }
        };
        long[] start = new long[this.numProbes];
        Future[] futs = new Future[this.numProbes];
        for (int i = 0; i < this.numProbes; ++i) {
            start[i] = System.nanoTime();
            futs[i] = this.executor.submit(task);
        }
        long[] res = new long[this.numProbes];
        Arrays.fill(res, -1L);
        try {
            for (int i = 0; i < this.numProbes; ++i) {
                long nanos = (Long)futs[i].get() - start[i];
                res[i] = TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
        return res;
    }
}

