/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.BasicSingleConsumerFloatQueue;
import co.paralleluniverse.strands.queues.CircularWordBuffer;

public class CircularFloatBuffer
extends CircularWordBuffer<Float>
implements BasicSingleConsumerFloatQueue {
    public CircularFloatBuffer(int size, boolean singleProducer) {
        super(size, singleProducer);
    }

    @Override
    public boolean enq(Float elem) {
        return this.enq(elem.floatValue());
    }

    @Override
    public boolean enq(float elem) {
        this.enqRaw(Float.floatToRawIntBits(elem));
        return true;
    }

    @Override
    public float pollFloat() {
        return ((FloatConsumer)this.consumer).pollFloat();
    }

    @Override
    public FloatConsumer newConsumer() {
        return new FloatConsumer();
    }

    public class FloatConsumer
    extends CircularWordBuffer.WordConsumer {
        public FloatConsumer() {
            super(CircularFloatBuffer.this);
        }

        public float getFloatValue() {
            return Float.intBitsToFloat(this.getRawValue());
        }

        protected Float getValue() {
            return Float.valueOf(this.getFloatValue());
        }

        public float pollFloat() {
            this.poll0();
            return this.getFloatValue();
        }
    }
}

